/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import org.junit.Assert;
import org.junit.Test;
import org.mortbay.thread.QueuedThreadPool;
import org.neo4j.server.web.Jetty6WebServer;

public class JettyThreadLimitTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldHaveSensibleDefaultJettyThreadPoolSize() throws Exception {
        Jetty6WebServer server = new Jetty6WebServer();
        server.setPort(7480);
        try {
            server.start();
            QueuedThreadPool threadPool = (QueuedThreadPool)server.getJetty().getThreadPool();
            threadPool.start();
            this.loadThreadPool(threadPool);
            Assert.assertEquals((long)(10 * Runtime.getRuntime().availableProcessors()), (long)threadPool.getThreads());
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldHaveConfigurableJettyThreadPoolSize() throws Exception {
        Jetty6WebServer server = new Jetty6WebServer();
        int maxThreads = 7;
        server.setMaxThreads(7);
        server.setPort(7480);
        try {
            server.start();
            QueuedThreadPool threadPool = (QueuedThreadPool)server.getJetty().getThreadPool();
            threadPool.start();
            this.loadThreadPool(threadPool);
            int threads = threadPool.getThreads();
            Assert.assertTrue((threads <= 7 ? 1 : 0) != 0);
        }
        finally {
            server.stop();
        }
    }

    private void loadThreadPool(QueuedThreadPool threadPool) {
        final CyclicBarrier cb = new CyclicBarrier(100);
        for (int i = 0; i < 100; ++i) {
            threadPool.dispatch(new Runnable(){

                @Override
                public void run() {
                    try {
                        cb.await();
                    }
                    catch (InterruptedException e) {
                    }
                    catch (BrokenBarrierException brokenBarrierException) {
                        // empty catch block
                    }
                }
            });
        }
    }
}

