/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.neo4j.server.ServerTestUtils;
import org.neo4j.server.configuration.DatabaseTuningPropertyFileBuilder;
import org.neo4j.server.configuration.PropertyFileBuilder;
import org.neo4j.server.configuration.PropertyFileConfigurator;
import org.neo4j.server.configuration.validation.ValidationRule;
import org.neo4j.server.configuration.validation.Validator;

public class ConfiguratorTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Test
    public void shouldProvideAConfiguration() throws IOException {
        File configFile = PropertyFileBuilder.builder(this.folder.newFile()).build();
        Configuration config = new PropertyFileConfigurator(new Validator(new ValidationRule[0]), configFile).configuration();
        Assert.assertNotNull((Object)config);
    }

    @Test
    public void shouldUseSpecifiedConfigFile() throws Exception {
        File configFile = PropertyFileBuilder.builder(this.folder.newFile()).withNameValue("foo", "bar").build();
        Configuration testConf = new PropertyFileConfigurator(new Validator(new ValidationRule[0]), configFile).configuration();
        String EXPECTED_VALUE = "bar";
        Assert.assertEquals((Object)"bar", (Object)testConf.getString("foo"));
    }

    @Test
    public void shouldAcceptDuplicateKeysWithSameValue() throws IOException {
        File configFile = PropertyFileBuilder.builder(this.folder.newFile()).withNameValue("foo", "bar").withNameValue("foo", "bar").build();
        PropertyFileConfigurator configurator = new PropertyFileConfigurator(configFile);
        Configuration testConf = configurator.configuration();
        Assert.assertNotNull((Object)testConf);
        String EXPECTED_VALUE = "bar";
        Assert.assertEquals((Object)"bar", (Object)testConf.getString("foo"));
    }

    @Test
    public void shouldSupportProvidingDatabaseTuningParametersSeparately() throws IOException {
        File databaseTuningPropertyFile = DatabaseTuningPropertyFileBuilder.builder().build();
        File propertyFileWithDbTuningProperty = PropertyFileBuilder.builder(this.folder.newFile()).withDbTuningPropertyFile(databaseTuningPropertyFile).build();
        PropertyFileConfigurator configurator = new PropertyFileConfigurator(propertyFileWithDbTuningProperty);
        Map databaseTuningProperties = configurator.getDatabaseTuningProperties();
        Assert.assertNotNull((Object)databaseTuningProperties);
        Assert.assertEquals((long)5L, (long)databaseTuningProperties.size());
    }

    @Test
    public void shouldFindThirdPartyJaxRsPackages() throws IOException {
        File file = ServerTestUtils.createTempPropertyFile(this.folder.getRoot());
        FileWriter fstream = new FileWriter(file, true);
        BufferedWriter out = new BufferedWriter(fstream);
        out.write("org.neo4j.server.thirdparty_jaxrs_classes");
        out.write("=");
        out.write("com.foo.bar=\"mount/point/foo\",");
        out.write("com.foo.baz=\"/bar\",");
        out.write("com.foo.foobarbaz=\"/\"");
        out.write(System.getProperty("line.separator"));
        out.close();
        PropertyFileConfigurator configurator = new PropertyFileConfigurator(file);
        Set thirdpartyJaxRsPackages = configurator.getThirdpartyJaxRsPackages();
        Assert.assertNotNull((Object)thirdpartyJaxRsPackages);
        Assert.assertEquals((long)3L, (long)thirdpartyJaxRsPackages.size());
    }
}

