/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.util.Collections;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.server.rest.repr.BadInputException;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.RelationshipRepresentation;
import org.neo4j.server.rest.repr.RepresentationTestAccess;
import org.neo4j.server.rest.repr.RepresentationTestBase;

public class RelationshipRepresentationTest {
    @Test
    public void shouldHaveSelfLink() throws BadInputException {
        RepresentationTestBase.assertUriMatches("http://.*/relationship/[0-9]+", this.relrep(1234L).selfUri());
    }

    @Test
    public void shouldHaveType() {
        Assert.assertNotNull((Object)this.relrep(1234L).getType());
    }

    @Test
    public void shouldHaveStartNodeLink() throws BadInputException {
        RepresentationTestBase.assertUriMatches("http://.*/node/[0-9]+", this.relrep(1234L).startNodeUri());
    }

    @Test
    public void shouldHaveEndNodeLink() throws BadInputException {
        RepresentationTestBase.assertUriMatches("http://.*/node/[0-9]+", this.relrep(1234L).endNodeUri());
    }

    @Test
    public void shouldHavePropertiesLink() throws BadInputException {
        RepresentationTestBase.assertUriMatches("http://.*/relationship/[0-9]+/properties", this.relrep(1234L).propertiesUri());
    }

    @Test
    public void shouldHavePropertyLinkTemplate() throws BadInputException {
        RepresentationTestBase.assertUriMatches("http://.*/relationship/[0-9]+/properties/\\{key\\}", this.relrep(1234L).propertyUriTemplate());
    }

    @Test
    public void shouldSerialiseToMap() {
        Map<String, Object> repr = RepresentationTestAccess.serialize((MappingRepresentation)this.relrep(1234L));
        Assert.assertNotNull(repr);
        RelationshipRepresentationTest.verifySerialisation(repr);
    }

    private RelationshipRepresentation relrep(long id) {
        return new RelationshipRepresentation(RelationshipRepresentationTest.relationship(id));
    }

    static Relationship relationship(long id) {
        Node startNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)startNode.getId()).thenReturn((Object)0L);
        Node endNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)endNode.getId()).thenReturn((Object)1L);
        RelationshipType type = (RelationshipType)Mockito.mock(RelationshipType.class);
        Mockito.when((Object)type.name()).thenReturn((Object)"LOVES");
        Relationship relationship = (Relationship)Mockito.mock(Relationship.class);
        Mockito.when((Object)relationship.getId()).thenReturn((Object)id);
        Mockito.when((Object)relationship.getPropertyKeys()).thenReturn(Collections.emptySet());
        Mockito.when((Object)relationship.getStartNode()).thenReturn((Object)startNode);
        Mockito.when((Object)relationship.getEndNode()).thenReturn((Object)endNode);
        Mockito.when((Object)relationship.getType()).thenReturn((Object)type);
        return relationship;
    }

    public static void verifySerialisation(Map<String, Object> relrep) {
        RepresentationTestBase.assertUriMatches("http://.*/relationship/[0-9]+", relrep.get("self").toString());
        RepresentationTestBase.assertUriMatches("http://.*/node/[0-9]+", relrep.get("start").toString());
        RepresentationTestBase.assertUriMatches("http://.*/node/[0-9]+", relrep.get("end").toString());
        Assert.assertNotNull((Object)relrep.get("type"));
        RepresentationTestBase.assertUriMatches("http://.*/relationship/[0-9]+/properties", relrep.get("properties").toString());
        RepresentationTestBase.assertUriMatches("http://.*/relationship/[0-9]+/properties/\\{key\\}", (String)relrep.get("property"));
        Assert.assertNotNull((Object)relrep.get("data"));
    }
}

