/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.impl.transaction.xaframework.ForceMode;
import org.neo4j.server.rest.web.RestfulGraphDatabase;

public class ModelBuilder {
    private static final ForceMode FORCE = ForceMode.forced;

    public static DomainModel generateMatrix(RestfulGraphDatabase rgd) {
        String key = "key_get";
        String value = "value";
        DomainModel dm = new DomainModel();
        DomainEntity thomas = new DomainEntity();
        thomas.properties.put("name", "Thomas Anderson");
        thomas.location = (URI)rgd.createNode(FORCE, "{\"name\":\"Thomas Anderson\"}").getMetadata().getFirst((Object)"Location");
        dm.add(thomas);
        DomainEntity agent = new DomainEntity();
        agent.properties.put("name", "Agent Smith");
        agent.location = (URI)rgd.createNode(FORCE, "{\"name\":\"Agent Smith\"}").getMetadata().getFirst((Object)"Location");
        dm.add(agent);
        dm.nodeIndexName = "matrixal-nodes";
        dm.indexedNodeKeyValues.put(key, value);
        dm.indexedNodeUriToEntityMap.put((URI)rgd.addToNodeIndex(FORCE, dm.nodeIndexName, null, null, "{\"key\": \"" + key + "\", \"value\":\"" + value + "\", \"uri\": \"" + thomas.location + "\"}").getMetadata().getFirst((Object)"Location"), thomas);
        dm.indexedNodeUriToEntityMap.put((URI)rgd.addToNodeIndex(FORCE, dm.nodeIndexName, null, null, "{\"key\": \"" + key + "\", \"value\":\"" + value + "\", \"uri\": \"" + agent.location + "\"}").getMetadata().getFirst((Object)"Location"), agent);
        return dm;
    }

    public static class DomainModel {
        public Map<URI, DomainEntity> nodeUriToEntityMap = new HashMap<URI, DomainEntity>();
        String nodeIndexName = "nodes";
        public Map<String, String> indexedNodeKeyValues = new HashMap<String, String>();
        public Map<URI, DomainEntity> indexedNodeUriToEntityMap = new HashMap<URI, DomainEntity>();
        String relationshipIndexName = "relationships";
        public Map<URI, DomainEntity> indexedRelationshipUriToEntityMap = new HashMap<URI, DomainEntity>();
        public Map<String, String> indexedRelationshipKeyValues = new HashMap<String, String>();

        public void add(DomainEntity de) {
            this.nodeUriToEntityMap.put(de.location, de);
        }
    }

    public static class DomainEntity {
        public URI location;
        public Map<String, String> properties = new HashMap<String, String>();
    }
}

