/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import com.sun.jersey.api.client.Client;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.server.NeoServer;
import org.neo4j.server.helpers.ServerHelper;
import org.neo4j.server.logging.InMemoryAppender;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.server.web.Jetty6WebServer;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class NeoServerStartupLoggingDocIT
extends ExclusiveServerTestBase {
    private static InMemoryAppender appender = new InMemoryAppender(Jetty6WebServer.log);
    private static NeoServer server;

    @BeforeClass
    public static void setupServer() throws IOException {
        server = ServerHelper.createNonPersistentServer();
    }

    @Before
    public void cleanTheDatabase() {
        ServerHelper.cleanTheDatabase(server);
    }

    @AfterClass
    public static void stopServer() {
        server.stop();
    }

    @Test
    public void shouldLogStartup() throws Exception {
        Assert.assertThat((Object)appender.toString().length(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        Client nonRedirectingClient = Client.create();
        nonRedirectingClient.setFollowRedirects(Boolean.valueOf(false));
        JaxRsResponse response = new RestRequest(server.baseUri(), nonRedirectingClient).get();
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(199))));
    }
}

