/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.server.ServerTestUtils;

public class PropertyFileBuilder {
    private String portNo = "7474";
    private String webAdminUri = "http://localhost:7474/db/manage/";
    private String webAdminDataUri = "http://localhost:7474/db/data/";
    private String dbTuningPropertyFile = null;
    private ArrayList<Tuple> nameValuePairs = new ArrayList();
    private File file;

    public static PropertyFileBuilder builder(File file) {
        return new PropertyFileBuilder(file);
    }

    private PropertyFileBuilder(File file) {
        this.file = file;
    }

    public File build() throws IOException {
        String dbDir = ServerTestUtils.createTempDir().getAbsolutePath();
        String rrdbDir = ServerTestUtils.createTempDir().getAbsolutePath();
        Map properties = MapUtil.stringMap((String[])new String[]{"org.neo4j.server.database.location", dbDir, "org.neo4j.server.webadmin.rrdb.location", rrdbDir, "org.neo4j.server.webadmin.management.uri", this.webAdminUri, "org.neo4j.server.webadmin.data.uri", this.webAdminDataUri});
        if (this.portNo != null) {
            properties.put("org.neo4j.server.webserver.port", this.portNo);
        }
        if (this.dbTuningPropertyFile != null) {
            properties.put("org.neo4j.server.db.tuning.properties", this.dbTuningPropertyFile);
        }
        for (Tuple t : this.nameValuePairs) {
            properties.put(t.name, t.value);
        }
        ServerTestUtils.writePropertiesToFile(properties, this.file);
        return this.file;
    }

    public PropertyFileBuilder withDbTuningPropertyFile(File f) {
        this.dbTuningPropertyFile = f.getAbsolutePath();
        return this;
    }

    public PropertyFileBuilder withNameValue(String name, String value) {
        this.nameValuePairs.add(new Tuple(name, value));
        return this;
    }

    public PropertyFileBuilder withDbTuningPropertyFile(String propertyFileLocation) {
        this.dbTuningPropertyFile = propertyFileLocation;
        return this;
    }

    private static class Tuple {
        public String name;
        public String value;

        public Tuple(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

