/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rrd;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.MapConfiguration;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.WrappingDatabase;
import org.neo4j.server.rrd.JobScheduler;
import org.neo4j.server.rrd.RrdFactory;
import org.neo4j.server.rrd.Sampleable;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.neo4j.test.TargetDirectory;
import org.rrd4j.ConsolFun;
import org.rrd4j.DsType;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDef;

public class RrdFactoryTest {
    private Configuration config;
    private Database db;
    TargetDirectory target = TargetDirectory.forTest(RrdFactoryTest.class);
    @Rule
    public TargetDirectory.TestDirectory testDirectory = this.target.cleanTestDirectory();

    @Before
    public void setUp() throws IOException {
        this.config = new MapConfiguration(new HashMap());
        this.db = new WrappingDatabase((AbstractGraphDatabase)new ImpermanentGraphDatabase(TargetDirectory.forTest(this.getClass()).directory("rrd", true).getAbsolutePath()));
    }

    @After
    public void tearDown() {
        this.db.getGraph().shutdown();
    }

    @Test
    public void shouldTakeDirectoryLocationFromConfig() throws Exception {
        String expected = this.testDirectory.directory().getAbsolutePath();
        this.config.addProperty("org.neo4j.server.webadmin.rrdb.location", (Object)expected);
        TestableRrdFactory factory = this.createRrdFactory();
        factory.createRrdDbAndSampler(this.db, new NullJobScheduler());
        Assert.assertThat((Object)factory.directoryUsed, (Matcher)CoreMatchers.is((Object)expected));
    }

    @Test
    public void recreateDatabaseIfWrongStepsize() throws Exception {
        String expected = this.testDirectory.directory().getAbsolutePath();
        this.config.addProperty("org.neo4j.server.webadmin.rrdb.location", (Object)expected);
        TestableRrdFactory factory = this.createRrdFactory();
        factory.createRrdDbAndSampler(this.db, new NullJobScheduler());
        Assert.assertThat((Object)factory.directoryUsed, (Matcher)CoreMatchers.is((Object)expected));
    }

    @Test
    public void shouldMoveAwayInvalidRrdFile() throws IOException {
        String expected = new File(this.testDirectory.directory(), "rrd-test").getAbsolutePath();
        this.config.addProperty("org.neo4j.server.webadmin.rrdb.location", (Object)expected);
        TestableRrdFactory factory = this.createRrdFactory();
        this.createInvalidRrdFile(expected);
        RrdDb rrdDbAndSampler = factory.createRrdDbAndSampler(this.db, new NullJobScheduler());
        this.assertSubdirectoryExists("rrd-test-invalid", factory.directoryUsed);
        rrdDbAndSampler.close();
    }

    private void createInvalidRrdFile(String expected) throws IOException {
        File rrd = new File(expected);
        RrdDef rrdDef = new RrdDef(rrd.getAbsolutePath(), 3000L);
        rrdDef.addDatasource("test", DsType.GAUGE, 1L, Double.NaN, Double.NaN);
        rrdDef.addArchive(ConsolFun.AVERAGE, 0.2, 1, 1600);
        RrdDb r = new RrdDb(rrdDef);
        r.close();
    }

    @Test
    public void shouldCreateRrdDirInTempLocationForImpermanentDatabases() throws IOException {
        String expected = this.testDirectory.directory().getAbsolutePath();
        TestableRrdFactory factory = this.createRrdFactory(expected);
        factory.createRrdDbAndSampler(this.db, new NullJobScheduler());
        Assert.assertThat((Object)factory.directoryUsed, (Matcher)CoreMatchers.is((Object)expected));
    }

    @Test
    public void shouldCreateRrdFileInDbSubdirectory() throws Exception {
        String storeDir = this.testDirectory.directory().getAbsolutePath();
        this.db = new WrappingDatabase((AbstractGraphDatabase)new GraphDatabaseFactory().newEmbeddedDatabase(storeDir));
        TestableRrdFactory factory = this.createRrdFactory();
        factory.createRrdDbAndSampler(this.db, new NullJobScheduler());
        String rrdParent = new File(factory.directoryUsed).getParent();
        Assert.assertThat((Object)rrdParent, (Matcher)CoreMatchers.is((Object)storeDir));
    }

    private void assertSubdirectoryExists(String directoryThatShouldExist, String directoryUsed) {
        String[] list;
        File parentFile = new File(directoryUsed).getParentFile();
        for (String aList : list = parentFile.list()) {
            if (!aList.startsWith(directoryThatShouldExist)) continue;
            return;
        }
        Assert.fail((String)String.format("Didn't find [%s] in [%s]", directoryThatShouldExist, directoryUsed));
    }

    private TestableRrdFactory createRrdFactory() {
        return new TestableRrdFactory(this.config, this.testDirectory.directory().getAbsolutePath());
    }

    private TestableRrdFactory createRrdFactory(String tempDir) {
        return new TestableRrdFactory(this.config, tempDir);
    }

    private static class NullJobScheduler
    implements JobScheduler {
        private NullJobScheduler() {
        }

        public void scheduleAtFixedRate(Runnable job, String name, long delay, long period) {
        }
    }

    private static class TestableRrdFactory
    extends RrdFactory {
        public String directoryUsed;
        private final String tempDir;

        public TestableRrdFactory(Configuration config, String tempDir) {
            super(config);
            this.tempDir = tempDir;
        }

        protected String tempDir() throws IOException {
            return this.tempDir;
        }

        protected RrdDb createRrdb(String inDirectory, Sampleable ... sampleables) {
            this.directoryUsed = inDirectory;
            return super.createRrdb(inDirectory, sampleables);
        }
    }
}

