/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.security.KeyStore;
import java.security.cert.Certificate;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.security.KeyStoreFactory;
import org.neo4j.server.security.KeyStoreInformation;
import org.neo4j.server.security.SslCertificateFactory;

public class KeyStoreFactoryTest {
    @Test
    public void shouldCreateKeyStoreForGivenKeyPair() throws Exception {
        File certificatePath = File.createTempFile("cert", "test");
        File privateKeyPath = File.createTempFile("privatekey", "test");
        File keyStorePath = File.createTempFile("keyStore", "test");
        new SslCertificateFactory().createSelfSignedCertificate(certificatePath, privateKeyPath, "some-hostname");
        KeyStoreInformation ks = new KeyStoreFactory().createKeyStore(keyStorePath, privateKeyPath, certificatePath);
        Assert.assertThat((Object)new File(ks.getKeyStorePath()).exists(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void shouldImportSingleCertificateWhenNotInAChain() throws Exception {
        File certificatePath = File.createTempFile("cert", "test");
        File privateKeyPath = File.createTempFile("privatekey", "test");
        File keyStorePath = File.createTempFile("keyStore", "test");
        new SslCertificateFactory().createSelfSignedCertificate(certificatePath, privateKeyPath, "some-hostname");
        KeyStoreInformation keyStoreInformation = new KeyStoreFactory().createKeyStore(keyStorePath, privateKeyPath, certificatePath);
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(new FileInputStream(keyStoreInformation.getKeyStorePath()), keyStoreInformation.getKeyStorePassword());
        Certificate[] chain = keyStore.getCertificateChain("key");
        Assert.assertEquals((String)("Single certificate expected not a chain of [" + chain.length + "]"), (long)1L, (long)chain.length);
    }

    @Test
    public void shouldImportAllCertificatesInAChain() throws Exception {
        File keyStorePath = File.createTempFile("keyStore", "test");
        File privateKeyPath = this.fileFromResources("/certificates/chained_key.der");
        File certificatePath = this.fileFromResources("/certificates/combined.pem");
        KeyStoreInformation keyStoreInformation = new KeyStoreFactory().createKeyStore(keyStorePath, privateKeyPath, certificatePath);
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(new FileInputStream(keyStoreInformation.getKeyStorePath()), keyStoreInformation.getKeyStorePassword());
        Certificate[] chain = keyStore.getCertificateChain("key");
        Assert.assertEquals((String)"3 certificates expected in chain: root, intermediary, and user's", (long)3L, (long)chain.length);
    }

    private File fileFromResources(String path) {
        URL url = this.getClass().getResource(path);
        return new File(url.getFile());
    }
}

