/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security;

import java.io.File;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.security.SslCertificateFactory;

public class TestSslCertificateFactory {
    @Test
    public void shouldCreateASelfSignedCertificate() throws Exception {
        File cPath = File.createTempFile("cert", "test");
        File pkPath = File.createTempFile("privatekey", "test");
        SslCertificateFactory sslFactory = new SslCertificateFactory();
        sslFactory.createSelfSignedCertificate(cPath, pkPath, "myhost");
        Certificate[] c = sslFactory.loadCertificates(cPath);
        Assert.assertThat((Object)c, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)c.length, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        PrivateKey pk = sslFactory.loadPrivateKey(pkPath);
        Assert.assertThat((Object)pk, (Matcher)Matchers.notNullValue());
    }
}

