/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webadmin.rest;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.formats.JsonFormat;
import org.neo4j.server.webadmin.rest.JmxService;

public class JmxServiceDocTest {
    public JmxService jmxService;
    private final URI uri = URI.create("http://peteriscool.com:6666/");

    @Test
    public void correctRepresentation() throws URISyntaxException, UnsupportedEncodingException {
        Response resp = this.jmxService.getServiceDefinition();
        Assert.assertEquals((long)200L, (long)resp.getStatus());
        String json = new String((byte[])resp.getEntity(), "UTF-8");
        MatcherAssert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"resources"));
        MatcherAssert.assertThat((Object)json, (Matcher)Matchers.containsString((String)this.uri.toString()));
        MatcherAssert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"jmx/domain/{domain}/{objectName}"));
    }

    @Test
    public void shouldListDomainsCorrectly() throws Exception {
        Response resp = this.jmxService.listDomains();
        Assert.assertEquals((long)200L, (long)resp.getStatus());
    }

    @Test
    public void testwork() throws Exception {
        this.jmxService.queryBeans("[\"*:*\"]");
    }

    @Before
    public void setUp() throws Exception {
        this.jmxService = new JmxService(new OutputFormat((RepresentationFormat)new JsonFormat(), this.uri, null), null);
    }
}

