/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webadmin.rest;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.WrappingDatabase;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.repr.InputFormat;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.formats.JsonFormat;
import org.neo4j.server.webadmin.console.ConsoleSessionFactory;
import org.neo4j.server.webadmin.console.ScriptSession;
import org.neo4j.server.webadmin.console.ShellSession;
import org.neo4j.server.webadmin.rest.console.ConsoleService;
import org.neo4j.shell.ShellSettings;
import org.neo4j.test.TestGraphDatabaseFactory;

public class Neo4jShellConsoleSessionDocTest
implements ConsoleSessionFactory {
    private static final String LN = System.getProperty("line.separator");
    private ConsoleService consoleService;
    private Database database;
    private final URI uri = URI.create("http://peteriscool.com:6666/");

    @Before
    public void setUp() throws Exception {
        this.database = new WrappingDatabase((AbstractGraphDatabase)new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig(ShellSettings.remote_shell_enabled, "true").newGraphDatabase());
        this.consoleService = new ConsoleService((ConsoleSessionFactory)this, this.database, new OutputFormat((RepresentationFormat)new JsonFormat(), this.uri, null));
    }

    @After
    public void shutdownDatabase() {
        this.database.getGraph().shutdown();
    }

    public ScriptSession createSession(String engineName, Database database) {
        return new ShellSession(database.getGraph());
    }

    @Test
    public void doesntMangleNewlines() throws Exception {
        Response response = this.consoleService.exec((InputFormat)new JsonFormat(), "{ \"command\" : \"start n=node(0) return n;\", \"engine\":\"shell\" }");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        String result = this.decode(response).get(0);
        String expected = "+-----------+" + LN + "| n         |" + LN + "+-----------+" + LN + "| Node[0]{} |" + LN + "+-----------+" + LN + "1 row";
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.containsString((String)expected));
    }

    private List<String> decode(Response response) throws UnsupportedEncodingException, JsonParseException {
        return (List)JsonHelper.readJson((String)new String((byte[])response.getEntity(), "UTF-8"));
    }

    public Iterable<String> supportedEngines() {
        return new ArrayList<String>(){
            {
                this.add("shell");
            }
        };
    }
}

