/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.server;

import java.io.IOException;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.neo4j.server.NeoServer;
import org.neo4j.server.helpers.ServerHelper;
import org.neo4j.test.server.ServerHolder;

public class SharedServerTestBase {
    private static boolean useExternal = Boolean.valueOf(System.getProperty("neo-server.external", "false"));
    private static String externalURL = System.getProperty("neo-server.external.url", "http://localhost:7474");
    private static NeoServer server;
    private static String serverUrl;

    protected static NeoServer server() {
        return server;
    }

    protected final void cleanDatabase() {
        if (!useExternal) {
            ServerHelper.cleanTheDatabase(server);
        }
    }

    public static String getServerURL() {
        return serverUrl;
    }

    @BeforeClass
    public static void allocateServer() throws IOException {
        if (useExternal) {
            serverUrl = externalURL;
        } else {
            server = ServerHolder.allocate();
            serverUrl = server.baseUri().toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass
    public static void releaseServer() {
        if (!useExternal) {
            try {
                ServerHolder.release(server);
            }
            finally {
                server = null;
            }
        }
    }
}

