/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import javax.ws.rs.core.MediaType;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RestRequest;

public class NeoServerDocIT
extends AbstractRestFunctionalTestBase {
    private FunctionalTestHelper functionalTestHelper;

    @Before
    public void cleanTheDatabase() {
        this.cleanDatabase();
        this.functionalTestHelper = new FunctionalTestHelper(NeoServerDocIT.server());
    }

    @Test
    public void whenServerIsStartedItshouldStartASingleDatabase() throws Exception {
        Assert.assertNotNull((Object)NeoServerDocIT.server().getDatabase());
    }

    @Test
    public void shouldRedirectRootToWebadmin() throws Exception {
        Assert.assertFalse((boolean)NeoServerDocIT.server().baseUri().toString().contains("webadmin"));
        JaxRsResponse response = RestRequest.req().get(NeoServerDocIT.server().baseUri().toString(), MediaType.TEXT_HTML_TYPE);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        Assert.assertThat((Object)response.getEntity(), (Matcher)Matchers.containsString((String)"webadmin"));
    }

    @Test
    public void serverShouldProvideAWelcomePage() throws Exception {
        JaxRsResponse response = RestRequest.req().get(this.functionalTestHelper.webAdminUri());
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        Assert.assertThat((Object)response.getHeaders().getFirst((Object)"Content-Type"), (Matcher)Matchers.containsString((String)"html"));
    }
}

