/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.util.ArrayList;
import org.apache.commons.configuration.Configuration;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.server.logging.Logger;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.rest.security.SecurityFilter;
import org.neo4j.server.rest.security.SecurityRule;
import org.neo4j.server.web.WebServer;

public class SecurityRulesModule
implements ServerModule {
    private final Logger log = Logger.getLogger(SecurityRulesModule.class);
    private final WebServer webServer;
    private final Configuration config;
    private SecurityFilter mountedFilter;

    public SecurityRulesModule(WebServer webServer, Configuration config) {
        this.webServer = webServer;
        this.config = config;
    }

    @Override
    public void start(StringLogger logger) {
        Iterable<SecurityRule> securityRules = this.getSecurityRules();
        this.mountedFilter = new SecurityFilter(securityRules);
        this.webServer.addFilter(this.mountedFilter, "/*");
        for (SecurityRule rule : securityRules) {
            this.log.info("Security rule [%s] installed on server", rule.getClass().getCanonicalName());
            System.out.println(String.format("Security rule [%s] installed on server", rule.getClass().getCanonicalName()));
        }
    }

    @Override
    public void stop() {
        this.mountedFilter.destroy();
    }

    private Iterable<SecurityRule> getSecurityRules() {
        ArrayList<SecurityRule> rules = new ArrayList<SecurityRule>();
        for (String classname : this.config.getStringArray("org.neo4j.server.rest.security_rules")) {
            try {
                rules.add((SecurityRule)Class.forName(classname).newInstance());
            }
            catch (Exception e) {
                this.log.error("Could not load server security rule [%s], exception details: ", classname, e.getMessage());
                e.printStackTrace();
            }
        }
        return rules;
    }
}

