/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.transaction.xaframework.ForceMode;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.info.DiagnosticsManager;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.server.InterruptThreadTimer;
import org.neo4j.server.NeoServer;
import org.neo4j.server.NeoServerProvider;
import org.neo4j.server.ServerStartupException;
import org.neo4j.server.configuration.ConfigurationProvider;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.database.CypherExecutor;
import org.neo4j.server.database.CypherExecutorProvider;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.DatabaseProvider;
import org.neo4j.server.database.GraphDatabaseServiceProvider;
import org.neo4j.server.database.InjectableProvider;
import org.neo4j.server.logging.Logger;
import org.neo4j.server.modules.RESTApiModule;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.plugins.PluginInvocatorProvider;
import org.neo4j.server.plugins.PluginManager;
import org.neo4j.server.preflight.PreFlightTasks;
import org.neo4j.server.preflight.PreflightFailedException;
import org.neo4j.server.rest.paging.LeaseManager;
import org.neo4j.server.rest.repr.InputFormatProvider;
import org.neo4j.server.rest.repr.OutputFormatProvider;
import org.neo4j.server.rest.repr.RepresentationFormatRepository;
import org.neo4j.server.rest.web.DatabaseActions;
import org.neo4j.server.rrd.RrdDbProvider;
import org.neo4j.server.security.KeyStoreFactory;
import org.neo4j.server.security.KeyStoreInformation;
import org.neo4j.server.security.SslCertificateFactory;
import org.neo4j.server.statistic.StatisticCollector;
import org.neo4j.server.web.SimpleUriBuilder;
import org.neo4j.server.web.WebServer;
import org.neo4j.server.web.WebServerProvider;
import org.neo4j.tooling.Clock;

public abstract class AbstractNeoServer
implements NeoServer {
    public static final Logger log = Logger.getLogger(AbstractNeoServer.class);
    protected Database database;
    protected CypherExecutor cypherExecutor;
    protected Configurator configurator;
    protected WebServer webServer;
    protected final StatisticCollector statisticsCollector = new StatisticCollector();
    private PreFlightTasks preflight;
    private final List<ServerModule> serverModules = new ArrayList<ServerModule>();
    private final SimpleUriBuilder uriBuilder = new SimpleUriBuilder();
    private InterruptThreadTimer interruptStartupTimer;
    private DatabaseActions databaseActions;
    private final DependencyResolver dependencyResolver = new DependencyResolver.Adapter(){

        private <T> T resolveKnownSingleDependency(Class<T> type) {
            if (type.equals(Database.class)) {
                return (T)AbstractNeoServer.this.database;
            }
            if (type.equals(PreFlightTasks.class)) {
                return (T)AbstractNeoServer.this.preflight;
            }
            if (type.equals(InterruptThreadTimer.class)) {
                return (T)AbstractNeoServer.this.interruptStartupTimer;
            }
            if (type.equals(Logging.class)) {
                DependencyResolver kernelDependencyResolver = AbstractNeoServer.this.database.getGraph().getDependencyResolver();
                return (T)kernelDependencyResolver.resolveDependency(Logging.class);
            }
            return null;
        }

        public <T> T resolveDependency(Class<T> type, DependencyResolver.SelectionStrategy selector) {
            return (T)selector.select(type, Iterables.option(this.resolveKnownSingleDependency(type)));
        }
    };
    private static final boolean SUCCESS = true;
    private static final boolean FAILURE = false;

    protected abstract PreFlightTasks createPreflightTasks();

    protected abstract Iterable<ServerModule> createServerModules();

    protected abstract Database createDatabase();

    protected abstract WebServer createWebServer();

    protected DatabaseActions createDatabaseActions() {
        return new DatabaseActions(this.database, new LeaseManager(Clock.REAL_CLOCK), ForceMode.forced, this.configurator.configuration().getBoolean("org.neo4j.server.script.sandboxing.enabled", Configurator.DEFAULT_SCRIPT_SANDBOXING_ENABLED));
    }

    @Override
    public void init() {
        this.preflight = this.createPreflightTasks();
        this.database = this.createDatabase();
        this.webServer = this.createWebServer();
        for (ServerModule moduleClass : this.createServerModules()) {
            this.registerModule(moduleClass);
        }
    }

    protected Logging getLogging() {
        return (Logging)this.dependencyResolver.resolveDependency(Logging.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws ServerStartupException {
        this.interruptStartupTimer = this.createInterruptStartupTimer();
        try {
            this.runPreflightTasks();
            this.interruptStartupTimer.startCountdown();
            try {
                this.database.start();
                this.databaseActions = this.createDatabaseActions();
                this.cypherExecutor = new CypherExecutor(this.database, this.getLogging().getMessagesLog(CypherExecutor.class));
                this.configureWebServer();
                this.cypherExecutor.start();
                DiagnosticsManager diagnosticsManager = this.database.getGraph().getDiagnosticsManager();
                StringLogger logger = diagnosticsManager.getTargetLog();
                logger.logMessage("--- SERVER STARTED START ---");
                diagnosticsManager.register(Configurator.DIAGNOSTICS, (Object)this.configurator);
                this.startModules(logger);
                this.startWebServer(logger);
                logger.logMessage("--- SERVER STARTED END ---", true);
            }
            finally {
                this.interruptStartupTimer.stopCountdown();
            }
        }
        catch (Throwable t) {
            Thread.interrupted();
            if (this.interruptStartupTimer.wasTriggered()) {
                throw new ServerStartupException("Startup took longer than " + this.interruptStartupTimer.getTimeoutMillis() + "ms, " + "and was stopped. You can disable this behavior by setting '" + "org.neo4j.server.startup_timeout" + "' to 0.", 1);
            }
            throw new ServerStartupException(String.format("Starting Neo4j Server failed: %s", t.getMessage()), t);
        }
    }

    public DependencyResolver getDependencyResolver() {
        return this.dependencyResolver;
    }

    protected InterruptThreadTimer createInterruptStartupTimer() {
        InterruptThreadTimer stopStartupTimer;
        long startupTimeout = this.getConfiguration().getInt("org.neo4j.server.startup_timeout", 120) * 1000;
        if (startupTimeout > 0L) {
            log.info("Setting startup timeout to: " + startupTimeout + "ms based on " + this.getConfiguration().getInt("org.neo4j.server.startup_timeout", -1), new Object[0]);
            stopStartupTimer = InterruptThreadTimer.createTimer(startupTimeout, Thread.currentThread());
        } else {
            stopStartupTimer = InterruptThreadTimer.createNoOpTimer();
        }
        return stopStartupTimer;
    }

    protected final void registerModule(ServerModule module) {
        this.serverModules.add(module);
    }

    private void startModules(StringLogger logger) {
        for (ServerModule module : this.serverModules) {
            module.start(logger);
        }
    }

    private void stopModules() {
        for (ServerModule module : this.serverModules) {
            try {
                module.stop();
            }
            catch (Exception e) {
                log.error(e);
            }
        }
    }

    private void runPreflightTasks() {
        if (!this.preflight.run()) {
            throw new PreflightFailedException(this.preflight.failedTask());
        }
    }

    @Override
    public Configuration getConfiguration() {
        return this.configurator.configuration();
    }

    private void configureWebServer() {
        int webServerPort = this.getWebServerPort();
        String webServerAddr = this.getWebServerAddress();
        int maxThreads = this.getMaxThreads();
        int sslPort = this.getHttpsPort();
        boolean sslEnabled = this.getHttpsEnabled();
        log.info("Starting HTTP on port :%s with %d threads available", webServerPort, maxThreads);
        this.webServer.setPort(webServerPort);
        this.webServer.setAddress(webServerAddr);
        this.webServer.setMaxThreads(maxThreads);
        this.webServer.setEnableHttps(sslEnabled);
        this.webServer.setHttpsPort(sslPort);
        this.webServer.setWadlEnabled(Boolean.valueOf(String.valueOf(this.getConfiguration().getProperty("unsupported_wadl_generation_enabled"))));
        this.webServer.setDefaultInjectables(this.createDefaultInjectables());
        if (sslEnabled) {
            log.info("Enabling HTTPS on port :%s", sslPort);
            this.webServer.setHttpsCertificateInformation(this.initHttpsKeyStore());
        }
    }

    private int getMaxThreads() {
        return this.configurator.configuration().containsKey("org.neo4j.server.webserver.maxthreads") ? this.configurator.configuration().getInt("org.neo4j.server.webserver.maxthreads") : this.defaultMaxWebServerThreads();
    }

    private int defaultMaxWebServerThreads() {
        return 10 * Runtime.getRuntime().availableProcessors();
    }

    private void startWebServer(StringLogger logger) {
        try {
            if (this.httpLoggingProperlyConfigured()) {
                this.webServer.setHttpLoggingConfiguration(new File(this.getConfiguration().getProperty("org.neo4j.server.http.log.config").toString()));
            }
            this.webServer.start();
            Integer limit = this.getConfiguration().getInteger("org.neo4j.server.webserver.limit.executiontime", null);
            if (limit != null) {
                this.webServer.addExecutionLimitFilter(limit, this.database.getGraph().getGuard());
            }
            if (logger != null) {
                logger.logMessage("Server started on: " + this.baseUri());
            }
            log.info("Remote interface ready and available at [%s]", this.baseUri());
        }
        catch (RuntimeException e) {
            log.error("Failed to start Neo Server on port [%d], reason [%s]", this.getWebServerPort(), e.getMessage());
            throw e;
        }
    }

    private boolean httpLoggingProperlyConfigured() {
        return this.loggingEnabled() && this.configLocated();
    }

    private boolean configLocated() {
        Object property = this.getConfiguration().getProperty("org.neo4j.server.http.log.config");
        return property != null && new File(String.valueOf(property)).exists();
    }

    private boolean loggingEnabled() {
        return "true".equals(String.valueOf(this.getConfiguration().getProperty("org.neo4j.server.http.log.enabled")));
    }

    protected int getWebServerPort() {
        return this.configurator.configuration().getInt("org.neo4j.server.webserver.port", 7474);
    }

    protected boolean getHttpsEnabled() {
        return this.configurator.configuration().getBoolean("org.neo4j.server.webserver.https.enabled", Configurator.DEFAULT_WEBSERVER_HTTPS_ENABLED);
    }

    protected int getHttpsPort() {
        return this.configurator.configuration().getInt("org.neo4j.server.webserver.https.port", 7473);
    }

    protected String getWebServerAddress() {
        return this.configurator.configuration().getString("org.neo4j.server.webserver.address", "localhost");
    }

    protected KeyStoreInformation initHttpsKeyStore() {
        File keystorePath = new File(this.configurator.configuration().getString("org.neo4j.server.webserver.https.keystore.location", "neo4j-home/ssl/keystore"));
        File privateKeyPath = new File(this.configurator.configuration().getString("org.neo4j.server.webserver.https.key.location", "neo4j-home/ssl/snakeoil.key"));
        File certificatePath = new File(this.configurator.configuration().getString("org.neo4j.server.webserver.https.cert.location", "neo4j-home/ssl/snakeoil.cert"));
        if (!certificatePath.exists()) {
            log.info("No SSL certificate found, generating a self-signed certificate..", new Object[0]);
            new SslCertificateFactory().createSelfSignedCertificate(certificatePath, privateKeyPath, this.getWebServerAddress());
        }
        return new KeyStoreFactory().createKeyStore(keystorePath, privateKeyPath, certificatePath);
    }

    @Override
    public void stop() {
        try {
            this.stopServerOnly();
            this.stopDatabase();
            log.info("Successfully shutdown database.", new Object[0]);
        }
        catch (Exception e) {
            log.warn("Failed to cleanly shutdown database.", new Object[0]);
        }
    }

    @Deprecated
    public void stopServerOnly() {
        try {
            this.stopWebServer();
            this.stopModules();
            log.info("Successfully shutdown Neo4j Server.", new Object[0]);
        }
        catch (Exception e) {
            log.warn("Failed to cleanly shutdown Neo4j Server.", new Object[0]);
        }
    }

    private void stopWebServer() {
        if (this.webServer != null) {
            this.webServer.stop();
        }
    }

    private void stopDatabase() {
        if (this.database != null) {
            try {
                this.database.stop();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }

    @Override
    public URI baseUri() {
        return this.uriBuilder.buildURI(this.getWebServerAddress(), this.getWebServerPort(), false);
    }

    public URI httpsUri() {
        return this.uriBuilder.buildURI(this.getWebServerAddress(), this.getHttpsPort(), true);
    }

    public WebServer getWebServer() {
        return this.webServer;
    }

    @Override
    public Configurator getConfigurator() {
        return this.configurator;
    }

    @Override
    public PluginManager getExtensionManager() {
        if (this.hasModule(RESTApiModule.class)) {
            return this.getModule(RESTApiModule.class).getPlugins();
        }
        return null;
    }

    protected Collection<InjectableProvider<?>> createDefaultInjectables() {
        ArrayList singletons = new ArrayList();
        Database database = this.getDatabase();
        singletons.add(new DatabaseProvider(database));
        singletons.add(new DatabaseActions.Provider(this.databaseActions));
        singletons.add(new GraphDatabaseServiceProvider(database));
        singletons.add(new NeoServerProvider(this));
        singletons.add(new ConfigurationProvider(this.getConfiguration()));
        singletons.add(new RrdDbProvider(database));
        singletons.add(new WebServerProvider(this.getWebServer()));
        PluginInvocatorProvider pluginInvocatorProvider = new PluginInvocatorProvider(this);
        singletons.add(pluginInvocatorProvider);
        RepresentationFormatRepository repository = new RepresentationFormatRepository(this);
        singletons.add(new InputFormatProvider(repository));
        singletons.add(new OutputFormatProvider(repository));
        singletons.add(new CypherExecutorProvider(this.cypherExecutor));
        return singletons;
    }

    private boolean hasModule(Class<? extends ServerModule> clazz) {
        for (ServerModule sm : this.serverModules) {
            if (sm.getClass() != clazz) continue;
            return true;
        }
        return false;
    }

    private <T extends ServerModule> T getModule(Class<T> clazz) {
        for (ServerModule sm : this.serverModules) {
            if (sm.getClass() != clazz) continue;
            return (T)sm;
        }
        return null;
    }
}

