/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.preflight;

import java.io.File;
import java.io.PrintStream;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.storemigration.ConfigMapUpgradeConfiguration;
import org.neo4j.kernel.impl.storemigration.CurrentDatabase;
import org.neo4j.kernel.impl.storemigration.DatabaseFiles;
import org.neo4j.kernel.impl.storemigration.StoreMigrator;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.UpgradableDatabase;
import org.neo4j.kernel.impl.storemigration.UpgradeConfiguration;
import org.neo4j.kernel.impl.storemigration.UpgradeNotAllowedByConfigurationException;
import org.neo4j.kernel.impl.storemigration.monitoring.MigrationProgressMonitor;
import org.neo4j.kernel.impl.storemigration.monitoring.VisibleMigrationProgressMonitor;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.server.logging.Logger;
import org.neo4j.server.preflight.PreflightTask;

public class PerformUpgradeIfNecessary
implements PreflightTask {
    private final Logger logger = Logger.getLogger(PerformUpgradeIfNecessary.class);
    private String failureMessage = "Unable to upgrade database";
    private final Configuration config;
    private final PrintStream out;
    private final Map<String, String> dbConfig;

    public PerformUpgradeIfNecessary(Configuration serverConfig, Map<String, String> dbConfig, PrintStream out) {
        this.config = serverConfig;
        this.dbConfig = dbConfig;
        this.out = out;
    }

    @Override
    public boolean run() {
        try {
            String dbLocation = new File(this.config.getString("org.neo4j.server.database.location")).getAbsolutePath();
            if (new CurrentDatabase(new StoreVersionCheck((FileSystemAbstraction)new DefaultFileSystemAbstraction())).storeFilesAtCurrentVersion(new File(dbLocation))) {
                return true;
            }
            File store = new File(dbLocation, "neostore");
            this.dbConfig.put("store_dir", dbLocation);
            this.dbConfig.put("neo_store", store.getPath());
            DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
            UpgradableDatabase upgradableDatabase = new UpgradableDatabase(new StoreVersionCheck((FileSystemAbstraction)fileSystem));
            if (!upgradableDatabase.storeFilesUpgradeable(store)) {
                return true;
            }
            Config conf = new Config(this.dbConfig, new Class[]{GraphDatabaseSettings.class});
            StoreUpgrader storeUpgrader = new StoreUpgrader(conf, StringLogger.SYSTEM, (UpgradeConfiguration)new ConfigMapUpgradeConfiguration(conf), upgradableDatabase, new StoreMigrator((MigrationProgressMonitor)new VisibleMigrationProgressMonitor(StringLogger.SYSTEM, this.out)), new DatabaseFiles((FileSystemAbstraction)fileSystem), (IdGeneratorFactory)new DefaultIdGeneratorFactory(), (FileSystemAbstraction)fileSystem);
            try {
                storeUpgrader.attemptUpgrade(store);
            }
            catch (UpgradeNotAllowedByConfigurationException e) {
                this.logger.info(e.getMessage(), new Object[0]);
                this.out.println(e.getMessage());
                this.failureMessage = e.getMessage();
                return false;
            }
            catch (StoreUpgrader.UnableToUpgradeException e) {
                this.logger.error(e);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.logger.error(e);
            return false;
        }
    }

    @Override
    public String getFailureMessage() {
        return this.failureMessage;
    }
}

