/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.neo4j.server.rest.security.SecurityRule;
import org.neo4j.server.rest.security.UriPathWildcardMatcher;

public class SecurityFilter
implements Filter {
    private final HashMap<UriPathWildcardMatcher, HashSet<SecurityRule>> rules = new HashMap();

    public SecurityFilter(SecurityRule rule, SecurityRule ... rules) {
        this(SecurityFilter.merge(rule, rules));
    }

    public SecurityFilter(Iterable<SecurityRule> securityRules) {
        for (SecurityRule r : securityRules) {
            UriPathWildcardMatcher uriPathWildcardMatcher;
            HashSet<SecurityRule> ruleHashSet;
            String rulePath = r.forUriPath();
            if (!rulePath.endsWith("*")) {
                rulePath = rulePath + "*";
            }
            if ((ruleHashSet = this.rules.get(uriPathWildcardMatcher = new UriPathWildcardMatcher(rulePath))) == null) {
                ruleHashSet = new HashSet();
                this.rules.put(uriPathWildcardMatcher, ruleHashSet);
            }
            ruleHashSet.add(r);
        }
    }

    private static Iterable<SecurityRule> merge(SecurityRule rule, SecurityRule[] rules) {
        ArrayList<SecurityRule> result = new ArrayList<SecurityRule>();
        result.add(rule);
        Collections.addAll(result, rules);
        return result;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.validateRequestType(request);
        this.validateResponseType(response);
        HttpServletRequest httpReq = (HttpServletRequest)request;
        String path = httpReq.getContextPath() + (httpReq.getPathInfo() == null ? "" : httpReq.getPathInfo());
        for (UriPathWildcardMatcher uriPathWildcardMatcher : this.rules.keySet()) {
            if (!uriPathWildcardMatcher.matches(path)) continue;
            HashSet<SecurityRule> securityRules = this.rules.get(uriPathWildcardMatcher);
            for (SecurityRule securityRule : securityRules) {
                if (securityRule.isAuthorized(httpReq)) continue;
                this.createUnauthorizedChallenge(response, securityRule);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    private void validateRequestType(ServletRequest request) throws ServletException {
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException(String.format("Expected HttpServletRequest, received [%s]", request.getClass().getCanonicalName()));
        }
    }

    private void validateResponseType(ServletResponse response) throws ServletException {
        if (!(response instanceof HttpServletResponse)) {
            throw new ServletException(String.format("Expected HttpServletResponse, received [%s]", response.getClass().getCanonicalName()));
        }
    }

    private void createUnauthorizedChallenge(ServletResponse response, SecurityRule rule) {
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        httpServletResponse.setStatus(401);
        httpServletResponse.addHeader("WWW-Authenticate", rule.wwwAuthenticateHeader());
    }

    public synchronized void destroy() {
        this.rules.clear();
    }

    public static String basicAuthenticationResponse(String realm) {
        return "Basic realm=\"" + realm + "\"";
    }
}

