/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.util.List;
import org.neo4j.kernel.logging.ConsoleLogger;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.server.JAXRSHelper;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.rest.discovery.DiscoveryService;
import org.neo4j.server.web.WebServer;

public class DiscoveryModule
implements ServerModule {
    private static final String ROOT_PATH = "/";
    private final WebServer webServer;
    private final ConsoleLogger log;

    public DiscoveryModule(WebServer webServer, Logging logging) {
        this.webServer = webServer;
        this.log = logging.getConsoleLog(this.getClass());
    }

    @Override
    public void start() {
        this.webServer.addJAXRSClasses(this.getClassNames(), ROOT_PATH, null);
        this.log.log("Mounted discovery module at [%s]", new Object[]{ROOT_PATH});
    }

    private List<String> getClassNames() {
        return JAXRSHelper.listFrom(DiscoveryService.class.getName());
    }

    @Override
    public void stop() {
        this.webServer.removeJAXRSClasses(this.getClassNames(), ROOT_PATH);
    }
}

