/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.util.ArrayList;
import org.apache.commons.configuration.Configuration;
import org.neo4j.kernel.logging.ConsoleLogger;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.rest.security.SecurityFilter;
import org.neo4j.server.rest.security.SecurityRule;
import org.neo4j.server.web.WebServer;

public class SecurityRulesModule
implements ServerModule {
    private final WebServer webServer;
    private final Configuration config;
    private final ConsoleLogger log;
    private SecurityFilter mountedFilter;

    public SecurityRulesModule(WebServer webServer, Configuration config, Logging logging) {
        this.webServer = webServer;
        this.config = config;
        this.log = logging.getConsoleLog(this.getClass());
    }

    @Override
    public void start() {
        Iterable<SecurityRule> securityRules = this.getSecurityRules();
        this.mountedFilter = new SecurityFilter(securityRules);
        this.webServer.addFilter(this.mountedFilter, "/*");
        for (SecurityRule rule : securityRules) {
            this.log.log("Security rule [%s] installed on server", new Object[]{rule.getClass().getCanonicalName()});
        }
    }

    @Override
    public void stop() {
        if (this.mountedFilter != null) {
            this.mountedFilter.destroy();
        }
    }

    private Iterable<SecurityRule> getSecurityRules() {
        ArrayList<SecurityRule> rules = new ArrayList<SecurityRule>();
        for (String classname : this.config.getStringArray("org.neo4j.server.rest.security_rules")) {
            try {
                rules.add((SecurityRule)Class.forName(classname).newInstance());
            }
            catch (Exception e) {
                this.log.error("Could not load server security rule [%s], exception details: ", new Object[]{classname, e.getMessage()});
                e.printStackTrace();
            }
        }
        return rules;
    }
}

