/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webadmin.console;

import org.neo4j.cypher.SyntaxException;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.logging.ConsoleLogger;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.server.database.CypherExecutor;
import org.neo4j.server.webadmin.console.ScriptSession;

public class CypherSession
implements ScriptSession {
    private final CypherExecutor cypherExecutor;
    private final ConsoleLogger log;

    public CypherSession(CypherExecutor cypherExecutor, Logging logging) {
        this.cypherExecutor = cypherExecutor;
        this.log = logging.getConsoleLog(this.getClass());
    }

    @Override
    public Pair<String, String> evaluate(String script) {
        String resultString;
        if (script.trim().equals("")) {
            return Pair.of((Object)"", null);
        }
        try {
            ExecutionResult result = this.cypherExecutor.getExecutionEngine().execute(script);
            resultString = result.dumpToString();
        }
        catch (SyntaxException error) {
            resultString = error.getMessage();
        }
        catch (Exception exception) {
            this.log.error("Unknown error executing cypher query", (Throwable)exception);
            resultString = "Error: " + exception.getClass().getSimpleName() + " - " + exception.getMessage();
        }
        return Pair.of((Object)resultString, null);
    }
}

