/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webadmin.rest.representations;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.webadmin.rest.AdvertisableService;

public class ServerRootRepresentation
extends MappingRepresentation {
    private HashMap<String, String> services = new HashMap();

    public ServerRootRepresentation(URI baseUri, Iterable<AdvertisableService> advertisableServices) {
        super("services");
        for (AdvertisableService svc : advertisableServices) {
            this.services.put(svc.getName(), baseUri.toString() + svc.getServerPath());
        }
    }

    public Map<String, Map<String, String>> serialize() {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        result.put("services", this.services);
        return result;
    }

    protected void serialize(MappingSerializer serializer) {
        MappingRepresentation apa = new MappingRepresentation("services"){

            protected void serialize(MappingSerializer serializer) {
                for (Map.Entry entry : ServerRootRepresentation.this.services.entrySet()) {
                    serializer.putString((String)entry.getKey(), (String)entry.getValue());
                }
            }
        };
        serializer.putMapping("services", apa);
    }
}

