/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.net.URI;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.neo4j.kernel.logging.ConsoleLogger;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.server.JAXRSHelper;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.web.WebServer;
import org.neo4j.server.webadmin.rest.JmxService;
import org.neo4j.server.webadmin.rest.MonitorService;
import org.neo4j.server.webadmin.rest.RootService;
import org.neo4j.server.webadmin.rest.console.ConsoleService;

public class ManagementApiModule
implements ServerModule {
    private final Configuration config;
    private final WebServer webServer;
    private final ConsoleLogger log;

    public ManagementApiModule(WebServer webServer, Configuration config, Logging logging) {
        this.webServer = webServer;
        this.config = config;
        this.log = logging.getConsoleLog(this.getClass());
    }

    @Override
    public void start() {
        String serverMountPoint = this.managementApiUri().toString();
        this.webServer.addJAXRSClasses(this.getClassNames(), serverMountPoint, null);
        this.log.log("Mounted management API at [%s]", new Object[]{serverMountPoint});
    }

    private List<String> getClassNames() {
        return JAXRSHelper.listFrom(JmxService.class.getName(), MonitorService.class.getName(), RootService.class.getName(), ConsoleService.class.getName());
    }

    @Override
    public void stop() {
        this.webServer.removeJAXRSClasses(this.getClassNames(), this.managementApiUri().toString());
    }

    private URI managementApiUri() {
        return URI.create(this.config.getString("org.neo4j.server.webadmin.management.uri", "/db/manage"));
    }
}

