/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.preflight;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.neo4j.kernel.impl.recovery.StoreRecoverer;
import org.neo4j.kernel.logging.ConsoleLogger;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.server.preflight.PreflightTask;

public class PerformRecoveryIfNecessary
implements PreflightTask {
    private final String failureMessage = "Unable to recover database";
    private final Configuration config;
    private final PrintStream out;
    private final Map<String, String> dbConfig;
    private final ConsoleLogger log;

    public PerformRecoveryIfNecessary(Configuration serverConfig, Map<String, String> dbConfig, PrintStream out, Logging logging) {
        this.config = serverConfig;
        this.dbConfig = dbConfig;
        this.out = out;
        this.log = logging.getConsoleLog(this.getClass());
    }

    @Override
    public boolean run() {
        try {
            StoreRecoverer recoverer;
            File dbLocation = new File(this.config.getString("org.neo4j.server.database.location"));
            if (dbLocation.exists() && (recoverer = new StoreRecoverer()).recoveryNeededAt(dbLocation, this.dbConfig)) {
                this.out.println("Detected incorrectly shut down database, performing recovery..");
                recoverer.recover(dbLocation, this.dbConfig);
            }
            return true;
        }
        catch (IOException e) {
            this.log.error("Recovery startup task failed.", (Throwable)e);
            return false;
        }
    }

    @Override
    public String getFailureMessage() {
        return "Unable to recover database";
    }
}

