/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.ServerStartupException;
import org.neo4j.server.helpers.ServerBuilder;
import org.neo4j.test.BufferingLogging;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class NeoServerPortConflictDocIT
extends ExclusiveServerTestBase {
    @Test
    public void shouldComplainIfServerPortIsAlreadyTaken() throws IOException {
        int contestedPort = 9999;
        ServerSocket socket = new ServerSocket(contestedPort, 0, InetAddress.getByName("0.0.0.0"));
        BufferingLogging logging = new BufferingLogging();
        CommunityNeoServer server = ServerBuilder.server((Logging)logging).onPort(contestedPort).onHost("0.0.0.0").usingDatabaseDir(this.folder.getRoot().getAbsolutePath()).build();
        try {
            server.start();
            Assert.fail((String)"Should have reported failure to start");
        }
        catch (ServerStartupException e) {
            // empty catch block
        }
        Assert.assertThat((Object)logging.toString(), (Matcher)Matchers.containsString((String)String.format("Failed to start Neo Server", new Object[0])));
        socket.close();
        server.stop();
    }
}

