/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.kernel.logging.DevNullLoggingService;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.NeoServer;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.PropertyFileConfigurator;
import org.neo4j.server.configuration.ThirdPartyJaxRsPackage;
import org.neo4j.server.database.Database;
import org.neo4j.server.modules.ThirdPartyJAXRSModule;
import org.neo4j.server.web.WebServer;

public class ThirdPartyJAXRSModuleTest {
    @Test
    public void shouldReportThirdPartyPackagesAtSpecifiedMount() throws Exception {
        WebServer webServer = (WebServer)Mockito.mock(WebServer.class);
        CommunityNeoServer neoServer = (CommunityNeoServer)Mockito.mock(CommunityNeoServer.class);
        Mockito.when((Object)neoServer.baseUri()).thenReturn((Object)new URI("http://localhost:7575"));
        Mockito.when((Object)neoServer.getWebServer()).thenReturn((Object)webServer);
        Logging logging = DevNullLoggingService.DEV_NULL;
        Mockito.when((Object)neoServer.getDatabase()).thenReturn((Object)new Database(logging));
        Configurator configurator = (Configurator)Mockito.mock(PropertyFileConfigurator.class);
        ArrayList<ThirdPartyJaxRsPackage> jaxRsPackages = new ArrayList<ThirdPartyJaxRsPackage>();
        String path = "/third/party/package";
        jaxRsPackages.add(new ThirdPartyJaxRsPackage("org.example.neo4j", path));
        Mockito.when((Object)configurator.getThirdpartyJaxRsPackages()).thenReturn(jaxRsPackages);
        Mockito.when((Object)neoServer.getConfigurator()).thenReturn((Object)configurator);
        ThirdPartyJAXRSModule module = new ThirdPartyJAXRSModule(webServer, configurator, logging, (NeoServer)neoServer);
        module.start();
        ((WebServer)Mockito.verify((Object)webServer)).addJAXRSPackages((List)Matchers.any(List.class), Matchers.anyString(), Matchers.anyCollection());
    }
}

