/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.core.util.StringKeyObjectValueIgnoreCaseMultivaluedMap;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

public class JaxRsResponse
extends Response {
    private final int status;
    private final MultivaluedMap<String, Object> metaData;
    private final MultivaluedMap<String, String> headers;
    private final URI location;
    private String data;
    private MediaType type;

    public JaxRsResponse(ClientResponse response) {
        this(response, JaxRsResponse.extractContent(response));
    }

    private static String extractContent(ClientResponse response) {
        if (response.getStatus() == Response.Status.NO_CONTENT.getStatusCode()) {
            return null;
        }
        return (String)response.getEntity(String.class);
    }

    public JaxRsResponse(ClientResponse response, String entity) {
        this.status = response.getStatus();
        this.metaData = this.extractMetaData(response);
        this.headers = this.extractHeaders(response);
        this.location = response.getLocation();
        this.type = response.getType();
        this.data = entity;
        response.close();
    }

    public String getEntity() {
        return this.data;
    }

    public int getStatus() {
        return this.status;
    }

    public MultivaluedMap<String, Object> getMetadata() {
        return this.metaData;
    }

    private MultivaluedMap<String, Object> extractMetaData(ClientResponse jettyResponse) {
        StringKeyObjectValueIgnoreCaseMultivaluedMap metadata = new StringKeyObjectValueIgnoreCaseMultivaluedMap();
        for (Map.Entry header : jettyResponse.getHeaders().entrySet()) {
            for (String value : (List)header.getValue()) {
                metadata.putSingle(header.getKey(), (Object)value);
            }
        }
        return metadata;
    }

    public MultivaluedMap<String, String> getHeaders() {
        return this.headers;
    }

    private MultivaluedMap<String, String> extractHeaders(ClientResponse jettyResponse) {
        return jettyResponse.getHeaders();
    }

    public URI getLocation() {
        return this.location;
    }

    public void close() {
    }

    public static JaxRsResponse extractFrom(ClientResponse clientResponse) {
        return new JaxRsResponse(clientResponse);
    }

    public MediaType getType() {
        return this.type;
    }
}

