/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import org.junit.Assert;
import org.junit.Test;
import org.mortbay.thread.QueuedThreadPool;
import org.neo4j.kernel.logging.DevNullLoggingService;
import org.neo4j.server.web.Jetty6WebServer;

public class JettyThreadLimitTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldHaveSensibleDefaultJettyThreadPoolSize() throws Exception {
        Jetty6WebServer server = new Jetty6WebServer(DevNullLoggingService.DEV_NULL);
        server.setPort(7480);
        try {
            server.start();
            QueuedThreadPool threadPool = (QueuedThreadPool)server.getJetty().getThreadPool();
            threadPool.start();
            int configuredMaxThreads = 10 * Runtime.getRuntime().availableProcessors();
            this.loadThreadPool(threadPool, configuredMaxThreads + 1);
            Assert.assertEquals((long)configuredMaxThreads, (long)threadPool.getThreads());
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldHaveConfigurableJettyThreadPoolSize() throws Exception {
        Jetty6WebServer server = new Jetty6WebServer(DevNullLoggingService.DEV_NULL);
        int maxThreads = 7;
        server.setMaxThreads(7);
        server.setPort(7480);
        try {
            server.start();
            QueuedThreadPool threadPool = (QueuedThreadPool)server.getJetty().getThreadPool();
            threadPool.start();
            int configuredMaxThreads = 7 * Runtime.getRuntime().availableProcessors();
            this.loadThreadPool(threadPool, configuredMaxThreads + 1);
            int threads = threadPool.getThreads();
            Assert.assertTrue((threads <= 7 ? 1 : 0) != 0);
        }
        finally {
            server.stop();
        }
    }

    private void loadThreadPool(QueuedThreadPool threadPool, int tasksToSubmit) {
        final CyclicBarrier cb = new CyclicBarrier(tasksToSubmit);
        for (int i = 0; i < tasksToSubmit; ++i) {
            threadPool.dispatch(new Runnable(){

                @Override
                public void run() {
                    try {
                        cb.await();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (BrokenBarrierException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }
}

