/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web.logging;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;
import java.util.UUID;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.NeoServer;
import org.neo4j.server.ServerStartupException;
import org.neo4j.server.configuration.MapBasedConfiguration;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.helpers.ServerBuilder;
import org.neo4j.server.preflight.EnsurePreparedForHttpLogging;
import org.neo4j.server.preflight.HTTPLoggingPreparednessRuleTest;
import org.neo4j.server.preflight.PreflightTask;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.test.AssertEventually;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class HTTPLoggingDocIT
extends ExclusiveServerTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void givenExplicitlyDisabledServerLoggingConfigurationShouldNotLogAccesses() throws Exception {
        File logDirectory = TargetDirectory.forTest(this.getClass()).directory("givenExplicitlyDisabledServerLoggingConfigurationShouldNotLogAccesses-logdir", true);
        FileUtils.forceMkdir((File)logDirectory);
        File confDir = TargetDirectory.forTest(this.getClass()).directory("givenExplicitlyDisabledServerLoggingConfigurationShouldNotLogAccesses-confdir", true);
        FileUtils.forceMkdir((File)confDir);
        File configFile = HTTPLoggingPreparednessRuleTest.createConfigFile(HTTPLoggingPreparednessRuleTest.createLogbackConfigXml(logDirectory), confDir);
        CommunityNeoServer server = ServerBuilder.server().withDefaultDatabaseTuning().withProperty("org.neo4j.server.http.log.enabled", "false").withProperty("org.neo4j.server.http.log.config", configFile.getPath()).usingDatabaseDir(TargetDirectory.forTest(this.getClass()).directory("givenExplicitlyDisabledServerLoggingConfigurationShouldNotLogAccesses-dbdir", true).getAbsolutePath()).build();
        try {
            server.start();
            FunctionalTestHelper functionalTestHelper = new FunctionalTestHelper((NeoServer)server);
            String query = "?implicitlyDisabled" + UUID.randomUUID().toString();
            JaxRsResponse response = new RestRequest().get(functionalTestHelper.webAdminUri() + query);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            response.close();
            Assert.assertFalse((boolean)this.occursIn(query, new File(logDirectory, "http.log")));
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void givenExplicitlyEnabledServerLoggingConfigurationShouldLogAccess() throws Exception {
        final File logDirectory = TargetDirectory.forTest(this.getClass()).directory("givenExplicitlyEnabledServerLoggingConfigurationShouldLogAccess-logdir", true);
        FileUtils.forceMkdir((File)logDirectory);
        File confDir = TargetDirectory.forTest(this.getClass()).directory("givenExplicitlyEnabledServerLoggingConfigurationShouldLogAccess-confdir", true);
        FileUtils.forceMkdir((File)confDir);
        File configFile = HTTPLoggingPreparednessRuleTest.createConfigFile(HTTPLoggingPreparednessRuleTest.createLogbackConfigXml(logDirectory), confDir);
        final String query = "?explicitlyEnabled=" + UUID.randomUUID().toString();
        CommunityNeoServer server = ServerBuilder.server().withDefaultDatabaseTuning().withProperty("org.neo4j.server.http.log.enabled", "true").withProperty("org.neo4j.server.http.log.config", configFile.getPath()).usingDatabaseDir(TargetDirectory.forTest(this.getClass()).directory("givenExplicitlyEnabledServerLoggingConfigurationShouldLogAccess-dbdir", true).getAbsolutePath()).build();
        try {
            server.start();
            FunctionalTestHelper functionalTestHelper = new FunctionalTestHelper((NeoServer)server);
            JaxRsResponse response = new RestRequest().get(functionalTestHelper.webAdminUri() + query);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            response.close();
            AssertEventually.assertEventually((String)"request appears in log", (int)5, (AssertEventually.Condition)new AssertEventually.Condition(){

                public boolean evaluate() {
                    return HTTPLoggingDocIT.this.occursIn(query, new File(logDirectory, "http.log"));
                }
            });
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void givenConfigurationWithUnwritableLogDirectoryShouldFailToStartServer() throws Exception {
        File confDir = TargetDirectory.forTest(this.getClass()).directory("confdir");
        FileUtils.forceMkdir((File)confDir);
        File unwritableLogDir = this.createUnwritableDirectory();
        File configFile = HTTPLoggingPreparednessRuleTest.createConfigFile(HTTPLoggingPreparednessRuleTest.createLogbackConfigXml(unwritableLogDir), confDir);
        MapBasedConfiguration config = new MapBasedConfiguration();
        config.setProperty("org.neo4j.server.http.log.enabled", (Object)"true");
        config.setProperty("org.neo4j.server.http.log.config", (Object)configFile.getPath());
        CommunityNeoServer server = ServerBuilder.server().withDefaultDatabaseTuning().withPreflightTasks(new PreflightTask[]{new EnsurePreparedForHttpLogging((Configuration)config)}).withProperty("org.neo4j.server.http.log.enabled", "true").withProperty("org.neo4j.server.http.log.config", configFile.getPath()).usingDatabaseDir(TargetDirectory.forTest(this.getClass()).directory("confdir").getAbsolutePath()).build();
        try {
            server.start();
            Assert.fail((String)"should have thrown exception");
        }
        catch (ServerStartupException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)JUnitMatchers.containsString((String)String.format("HTTP log directory [%s]", unwritableLogDir.getAbsolutePath())));
        }
        finally {
            server.stop();
        }
    }

    private File createUnwritableDirectory() {
        File file;
        if (GraphDatabaseSetting.osIsWindows()) {
            file = new File("\\\\" + UUID.randomUUID().toString() + "\\http.log");
        } else {
            TargetDirectory targetDirectory = TargetDirectory.forTest(this.getClass());
            file = targetDirectory.file("unwritable-" + System.currentTimeMillis());
            file.mkdirs();
            file.setWritable(false, false);
        }
        return file;
    }

    private boolean occursIn(String lookFor, File file) {
        if (!file.exists()) {
            return false;
        }
        Scanner scanner = null;
        try {
            scanner = new Scanner(file);
            while (scanner.hasNext()) {
                if (!scanner.next().contains(lookFor)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
    }
}

