/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.logging;

import java.util.IllegalFormatException;
import org.mortbay.log.Logger;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.Logging;

public class JettyLoggerAdapter
implements Logger {
    private boolean debugEnabled;
    private final Logging logging;
    private final StringLogger logger;

    public JettyLoggerAdapter(Logging logging) {
        this.logging = logging;
        this.logger = StringLogger.SYSTEM;
        this.debugEnabled = this.logger.isDebugEnabled();
    }

    private JettyLoggerAdapter(Logging logging, StringLogger logger) {
        this.logging = logging;
        this.logger = logger;
        this.debugEnabled = logger.isDebugEnabled();
    }

    public void debug(String arg0, Throwable arg1) {
        if (this.debugEnabled) {
            try {
                this.logger.debug(JettyLoggerAdapter.wrapNull(arg0), arg1);
            }
            catch (IllegalFormatException e) {
                this.logger.debug(JettyLoggerAdapter.safeFormat(arg0, arg1));
            }
        }
    }

    public void debug(String arg0, Object arg1, Object arg2) {
        if (this.debugEnabled) {
            try {
                this.logger.debug(String.format(JettyLoggerAdapter.wrapNull(arg0), arg1, arg2));
            }
            catch (IllegalFormatException e) {
                this.logger.debug(JettyLoggerAdapter.safeFormat(arg0, arg1, arg2));
            }
        }
    }

    public Logger getLogger(String arg0) {
        Class<Object> cls = null;
        try {
            cls = Class.forName(arg0);
        }
        catch (ClassNotFoundException e) {
            cls = JettyLoggerAdapter.class;
        }
        return new JettyLoggerAdapter(this.logging, this.logging.getMessagesLog(cls));
    }

    public void info(String arg0, Object arg1, Object arg2) {
        try {
            this.logger.info(String.format(JettyLoggerAdapter.wrapNull(arg0), arg1, arg2));
        }
        catch (IllegalFormatException e) {
            this.logger.info(JettyLoggerAdapter.safeFormat(arg0, arg1, arg2));
        }
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public void setDebugEnabled(boolean arg0) {
    }

    public void warn(String arg0, Throwable arg1) {
        this.logger.warn(JettyLoggerAdapter.wrapNull(arg1));
    }

    public void warn(String arg0, Object arg1, Object arg2) {
        try {
            this.logger.warn(String.format(JettyLoggerAdapter.wrapNull(arg0), arg1, arg2));
        }
        catch (IllegalFormatException e) {
            this.logger.warn(JettyLoggerAdapter.safeFormat(arg0, arg1, arg2));
        }
    }

    static String safeFormat(String arg0, Object ... args) {
        StringBuilder builder = new StringBuilder();
        builder.append("Failed to format message: ");
        builder.append(JettyLoggerAdapter.armored(arg0));
        if (null != args) {
            for (int i = 0; i < args.length; ++i) {
                JettyLoggerAdapter.appendArg(builder, i + 1, args[i]);
            }
        }
        return builder.toString();
    }

    private static String armored(Object arg0) {
        return JettyLoggerAdapter.wrapNull(arg0).replaceAll("%", "?");
    }

    private static void appendArg(StringBuilder builder, int argNum, Object arg) {
        builder.append(" arg");
        builder.append(argNum);
        builder.append(": ");
        builder.append(JettyLoggerAdapter.armored(arg));
    }

    private static String wrapNull(Object arg0) {
        return null == arg0 ? "null" : arg0.toString();
    }
}

