/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import org.apache.commons.configuration.Configuration;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.statistic.StatisticCollector;
import org.neo4j.server.statistic.StatisticFilter;
import org.neo4j.server.web.WebServer;

public class StatisticModule
implements ServerModule {
    private final StatisticFilter filter;
    private final WebServer webServer;
    private final Configuration config;

    public StatisticModule(WebServer webServer, StatisticCollector requestStatistics, Configuration config) {
        this.webServer = webServer;
        this.config = config;
        this.filter = new StatisticFilter(requestStatistics);
    }

    @Override
    public void start() {
        if (this.isStatisticsEnabled()) {
            this.webServer.addFilter(this.filter, "/*");
        }
    }

    @Override
    public void stop() {
        if (this.isStatisticsEnabled()) {
            this.webServer.removeFilter(this.filter, "/*");
        }
    }

    private boolean isStatisticsEnabled() {
        return this.config.getBoolean("org.neo4j.server.webserver.statistics", false);
    }
}

