/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.io.IOException;
import org.apache.commons.configuration.Configuration;
import org.neo4j.kernel.logging.ConsoleLogger;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.server.RoundRobinJobScheduler;
import org.neo4j.server.database.Database;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.rrd.RrdFactory;
import org.neo4j.server.web.WebServer;
import org.rrd4j.core.RrdDb;

public class WebAdminModule
implements ServerModule {
    private static final String DEFAULT_WEB_ADMIN_PATH = "/webadmin";
    private static final String DEFAULT_WEB_ADMIN_STATIC_WEB_CONTENT_LOCATION = "webadmin-html";
    private final RoundRobinJobScheduler jobScheduler;
    private final Configuration config;
    private final WebServer webServer;
    private final Database database;
    private RrdDb rrdDb;
    private final ConsoleLogger log;
    private final Logging logging;

    public WebAdminModule(WebServer webServer, Configuration config, Logging logging, Database database) {
        this.webServer = webServer;
        this.config = config;
        this.logging = logging;
        this.log = logging.getConsoleLog(this.getClass());
        this.database = database;
        this.jobScheduler = new RoundRobinJobScheduler(logging);
    }

    @Override
    public void start() {
        try {
            this.startRoundRobinDB();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.webServer.addStaticContent(DEFAULT_WEB_ADMIN_STATIC_WEB_CONTENT_LOCATION, DEFAULT_WEB_ADMIN_PATH);
        this.log.log("Mounted webadmin at [%s]", new Object[]{DEFAULT_WEB_ADMIN_PATH});
    }

    @Override
    public void stop() {
        this.jobScheduler.stopJobs();
        this.webServer.removeStaticContent(DEFAULT_WEB_ADMIN_STATIC_WEB_CONTENT_LOCATION, DEFAULT_WEB_ADMIN_PATH);
        try {
            if (this.rrdDb != null) {
                this.rrdDb.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void startRoundRobinDB() throws IOException {
        RrdFactory rrdFactory = new RrdFactory(this.config, this.logging);
        this.rrdDb = rrdFactory.createRrdDbAndSampler(this.database, this.jobScheduler);
        this.database.setRrdDb(this.rrdDb);
    }
}

