/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.statistic;

import javax.servlet.Filter;
import org.mortbay.component.LifeCycle;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.FilterHolder;
import org.neo4j.kernel.logging.ConsoleLogger;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.server.statistic.StatisticFilter;

public class StatisticStartupListener
implements LifeCycle.Listener {
    private final Server jetty;
    private final FilterHolder holder;
    private final ConsoleLogger log;

    public StatisticStartupListener(Server jetty, StatisticFilter statisticFilter, Logging logging) {
        this.jetty = jetty;
        this.holder = new FilterHolder((Filter)statisticFilter);
        this.log = logging.getConsoleLog(this.getClass());
    }

    public void lifeCycleStarting(LifeCycle event) {
    }

    public void lifeCycleStarted(LifeCycle event) {
        for (Handler handler : this.jetty.getHandlers()) {
            if (!(handler instanceof Context)) continue;
            Context context = (Context)handler;
            String path = context.getContextPath();
            this.log.log("adding statistic-filter to " + path);
            context.addFilter(this.holder, "/*", 15);
        }
    }

    public void lifeCycleFailure(LifeCycle event, Throwable cause) {
    }

    public void lifeCycleStopping(LifeCycle event) {
        this.log.log("stopping filter");
        this.holder.doStop();
    }

    public void lifeCycleStopped(LifeCycle event) {
    }

    public void stop() {
        this.log.log("stopping listeneer");
        this.jetty.removeLifeCycleListener((LifeCycle.Listener)this);
    }
}

