/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.info.DiagnosticsManager;
import org.neo4j.server.InterruptThreadTimer;
import org.neo4j.server.NeoServer;
import org.neo4j.server.NeoServerProvider;
import org.neo4j.server.ServerStartupException;
import org.neo4j.server.configuration.ConfigurationProvider;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.database.CypherExecutor;
import org.neo4j.server.database.CypherExecutorProvider;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.DatabaseProvider;
import org.neo4j.server.database.GraphDatabaseServiceProvider;
import org.neo4j.server.database.InjectableProvider;
import org.neo4j.server.logging.Logger;
import org.neo4j.server.modules.RESTApiModule;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.plugins.Injectable;
import org.neo4j.server.plugins.PluginInvocatorProvider;
import org.neo4j.server.plugins.PluginManager;
import org.neo4j.server.plugins.TypedInjectable;
import org.neo4j.server.preflight.PreFlightTasks;
import org.neo4j.server.preflight.PreflightFailedException;
import org.neo4j.server.rest.paging.LeaseManagerProvider;
import org.neo4j.server.rest.repr.InputFormatProvider;
import org.neo4j.server.rest.repr.OutputFormatProvider;
import org.neo4j.server.rest.repr.RepresentationFormatRepository;
import org.neo4j.server.rrd.RrdDbProvider;
import org.neo4j.server.security.KeyStoreFactory;
import org.neo4j.server.security.KeyStoreInformation;
import org.neo4j.server.security.SslCertificateFactory;
import org.neo4j.server.statistic.StatisticCollector;
import org.neo4j.server.web.InjectableWrapper;
import org.neo4j.server.web.SimpleUriBuilder;
import org.neo4j.server.web.WebServer;
import org.neo4j.server.web.WebServerProvider;

public abstract class AbstractNeoServer
implements NeoServer {
    public static final Logger log = Logger.getLogger(AbstractNeoServer.class);
    protected Database database;
    protected CypherExecutor cypherExecutor;
    protected Configurator configurator;
    protected WebServer webServer;
    protected final StatisticCollector statisticsCollector = new StatisticCollector();
    private PreFlightTasks preflight;
    private final List<ServerModule> serverModules = new ArrayList<ServerModule>();
    private final SimpleUriBuilder uriBuilder = new SimpleUriBuilder();
    private InterruptThreadTimer interruptStartupTimer;
    private DependencyResolver dependencyResolver = new DependencyResolver(){

        public <T> T resolveDependency(Class<T> type) throws IllegalArgumentException {
            if (type.equals(Database.class)) {
                return (T)AbstractNeoServer.this.database;
            }
            if (type.equals(PreFlightTasks.class)) {
                return (T)AbstractNeoServer.this.preflight;
            }
            if (type.equals(InterruptThreadTimer.class)) {
                return (T)AbstractNeoServer.this.interruptStartupTimer;
            }
            throw new IllegalArgumentException("Could not resolve dependency of type:" + type.getName());
        }
    };

    protected abstract PreFlightTasks createPreflightTasks();

    protected abstract Iterable<ServerModule> createServerModules();

    protected abstract Database createDatabase();

    protected abstract WebServer createWebServer();

    @Override
    public void init() {
        this.preflight = this.createPreflightTasks();
        this.database = this.createDatabase();
        this.cypherExecutor = new CypherExecutor(this.database);
        this.webServer = this.createWebServer();
        for (ServerModule moduleClass : this.createServerModules()) {
            this.registerModule(moduleClass);
        }
    }

    @Override
    public void start() throws ServerStartupException {
        this.interruptStartupTimer = this.createInterruptStartupTimer();
        try {
            this.runPreflightTasks();
            this.interruptStartupTimer.startCountdown();
            this.configureWebServer();
            this.database.start();
            this.cypherExecutor.start();
            DiagnosticsManager diagnosticsManager = this.database.getGraph().getDiagnosticsManager();
            StringLogger logger = diagnosticsManager.getTargetLog();
            logger.logMessage("--- SERVER STARTED START ---");
            diagnosticsManager.register(Configurator.DIAGNOSTICS, (Object)this.configurator);
            this.startModules(logger);
            this.startWebServer(logger);
            logger.logMessage("--- SERVER STARTED END ---", true);
            this.interruptStartupTimer.stopCountdown();
        }
        catch (Throwable t) {
            this.interruptStartupTimer.stopCountdown();
            Thread.interrupted();
            if (this.interruptStartupTimer.wasTriggered()) {
                throw new ServerStartupException("Startup took longer than " + this.interruptStartupTimer.getTimeoutMillis() + "ms, and was stopped. You can disable this behavior by setting '" + "org.neo4j.server.startup_timeout" + "' to 0.", 1);
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new ServerStartupException("Starting neo server failed, see nested exception.", t);
        }
    }

    public DependencyResolver getDependencyResolver() {
        return this.dependencyResolver;
    }

    protected InterruptThreadTimer createInterruptStartupTimer() {
        InterruptThreadTimer stopStartupTimer;
        long startupTimeout = this.getConfiguration().getInt("org.neo4j.server.startup_timeout", 120) * 1000;
        if (startupTimeout > 0L) {
            log.info("Setting startup timeout to: " + startupTimeout + "ms based on " + this.getConfiguration().getInt("org.neo4j.server.startup_timeout", -1), new Object[0]);
            stopStartupTimer = InterruptThreadTimer.createTimer(startupTimeout, Thread.currentThread());
        } else {
            stopStartupTimer = InterruptThreadTimer.createNoOpTimer();
        }
        return stopStartupTimer;
    }

    protected final void registerModule(ServerModule module) {
        this.serverModules.add(module);
    }

    private void startModules(StringLogger logger) {
        for (ServerModule module : this.serverModules) {
            module.start(logger);
        }
    }

    private void stopModules() {
        for (ServerModule module : this.serverModules) {
            try {
                module.stop();
            }
            catch (Exception e) {
                log.error(e);
            }
        }
    }

    private void runPreflightTasks() {
        if (!this.preflight.run()) {
            throw new PreflightFailedException(this.preflight.failedTask());
        }
    }

    @Override
    public Configuration getConfiguration() {
        return this.configurator.configuration();
    }

    private void configureWebServer() {
        int webServerPort = this.getWebServerPort();
        String webServerAddr = this.getWebServerAddress();
        int maxThreads = this.getMaxThreads();
        int sslPort = this.getHttpsPort();
        boolean sslEnabled = this.getHttpsEnabled();
        log.info("Starting Neo Server on port [%s] with [%d] threads available", webServerPort, maxThreads);
        this.webServer.setPort(webServerPort);
        this.webServer.setAddress(webServerAddr);
        this.webServer.setMaxThreads(maxThreads);
        this.webServer.setEnableHttps(sslEnabled);
        this.webServer.setHttpsPort(sslPort);
        this.webServer.setWadlEnabled(Boolean.valueOf(String.valueOf(this.getConfiguration().getProperty("unsupported_wadl_generation_enabled"))));
        this.webServer.setDefaultInjectables(this.createDefaultInjectables());
        if (sslEnabled) {
            log.info("Enabling HTTPS on port [%s]", sslPort);
            this.webServer.setHttpsCertificateInformation(this.initHttpsKeyStore());
        }
    }

    private int getMaxThreads() {
        return this.configurator.configuration().containsKey("org.neo4j.server.webserver.maxthreads") ? this.configurator.configuration().getInt("org.neo4j.server.webserver.maxthreads") : this.defaultMaxWebServerThreads();
    }

    private int defaultMaxWebServerThreads() {
        return 10 * Runtime.getRuntime().availableProcessors();
    }

    private void startWebServer(StringLogger logger) {
        try {
            Integer limit;
            if (this.httpLoggingProperlyConfigured()) {
                this.webServer.setHttpLoggingConfiguration(new File(this.getConfiguration().getProperty("org.neo4j.server.http.log.config").toString()));
            }
            if ((limit = this.getConfiguration().getInteger("org.neo4j.server.webserver.limit.executiontime", null)) != null) {
                this.webServer.addExecutionLimitFilter(limit, this.database.getGraph().getGuard());
            }
            this.webServer.start();
            if (logger != null) {
                logger.logMessage("Server started on: " + this.baseUri());
            }
            log.info("Server started on [%s]", this.baseUri());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Failed to start Neo Server on port [%d], reason [%s]", this.getWebServerPort(), e.getMessage());
        }
    }

    private boolean httpLoggingProperlyConfigured() {
        return this.loggingEnabled() && this.configLocated();
    }

    private boolean configLocated() {
        Object property = this.getConfiguration().getProperty("org.neo4j.server.http.log.config");
        if (property == null) {
            return false;
        }
        return new File(String.valueOf(property)).exists();
    }

    private boolean loggingEnabled() {
        return "true".equals(String.valueOf(this.getConfiguration().getProperty("org.neo4j.server.http.log.enabled")));
    }

    protected int getWebServerPort() {
        return this.configurator.configuration().getInt("org.neo4j.server.webserver.port", 7474);
    }

    protected boolean getHttpsEnabled() {
        return this.configurator.configuration().getBoolean("org.neo4j.server.webserver.https.enabled", Configurator.DEFAULT_WEBSERVER_HTTPS_ENABLED);
    }

    protected int getHttpsPort() {
        return this.configurator.configuration().getInt("org.neo4j.server.webserver.https.port", 7473);
    }

    protected String getWebServerAddress() {
        return this.configurator.configuration().getString("org.neo4j.server.webserver.address", "localhost");
    }

    protected KeyStoreInformation initHttpsKeyStore() {
        File keystorePath = new File(this.configurator.configuration().getString("org.neo4j.server.webserver.https.keystore.location", "neo4j-home/ssl/keystore"));
        File privateKeyPath = new File(this.configurator.configuration().getString("org.neo4j.server.webserver.https.key.location", "neo4j-home/ssl/snakeoil.key"));
        File certificatePath = new File(this.configurator.configuration().getString("org.neo4j.server.webserver.https.cert.location", "neo4j-home/ssl/snakeoil.cert"));
        if (!certificatePath.exists()) {
            log.info("No SSL certificate found, generating a self-signed certificate..", new Object[0]);
            SslCertificateFactory certFactory = new SslCertificateFactory();
            certFactory.createSelfSignedCertificate(certificatePath, privateKeyPath, this.getWebServerAddress());
        }
        KeyStoreFactory keyStoreFactory = new KeyStoreFactory();
        return keyStoreFactory.createKeyStore(keystorePath, privateKeyPath, certificatePath);
    }

    @Override
    public void stop() {
        try {
            this.stopServerOnly();
            this.stopDatabase();
            log.info("Successfully shutdown database.", new Object[0]);
        }
        catch (Exception e) {
            log.warn("Failed to cleanly shutdown database.", new Object[0]);
        }
    }

    @Deprecated
    public void stopServerOnly() {
        try {
            this.stopWebServer();
            this.stopModules();
            log.info("Successfully shutdown Neo4j Server.", new Object[0]);
        }
        catch (Exception e) {
            log.warn("Failed to cleanly shutdown Neo4j Server.", new Object[0]);
        }
    }

    private void stopWebServer() {
        if (this.webServer != null) {
            this.webServer.stop();
        }
    }

    private void stopDatabase() {
        if (this.database != null) {
            try {
                this.database.stop();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }

    @Override
    public URI baseUri() {
        return this.uriBuilder.buildURI(this.getWebServerAddress(), this.getWebServerPort(), false);
    }

    public URI httpsUri() {
        return this.uriBuilder.buildURI(this.getWebServerAddress(), this.getHttpsPort(), true);
    }

    public WebServer getWebServer() {
        return this.webServer;
    }

    @Override
    public Configurator getConfigurator() {
        return this.configurator;
    }

    @Override
    public PluginManager getExtensionManager() {
        if (this.hasModule(RESTApiModule.class)) {
            return this.getModule(RESTApiModule.class).getPlugins();
        }
        return null;
    }

    protected Collection<InjectableProvider<?>> createDefaultInjectables() {
        ArrayList singletons = new ArrayList();
        Database database = this.getDatabase();
        singletons.add(new LeaseManagerProvider());
        singletons.add(new DatabaseProvider(database));
        singletons.add(new GraphDatabaseServiceProvider(database));
        singletons.add(new NeoServerProvider(this));
        singletons.add(new ConfigurationProvider(this.getConfiguration()));
        singletons.add(new RrdDbProvider(database));
        singletons.add(new WebServerProvider(this.getWebServer()));
        PluginInvocatorProvider pluginInvocatorProvider = new PluginInvocatorProvider(this);
        singletons.add(pluginInvocatorProvider);
        RepresentationFormatRepository repository = new RepresentationFormatRepository(this);
        singletons.add(new InputFormatProvider(repository));
        singletons.add(new OutputFormatProvider(repository));
        singletons.add(new CypherExecutorProvider(this.cypherExecutor));
        return singletons;
    }

    private InjectableWrapper toInjectableProvider(Object service) {
        return new InjectableWrapper((Injectable)TypedInjectable.injectable((Object)service));
    }

    private boolean hasModule(Class<? extends ServerModule> clazz) {
        for (ServerModule sm : this.serverModules) {
            if (sm.getClass() != clazz) continue;
            return true;
        }
        return false;
    }

    private <T extends ServerModule> T getModule(Class<T> clazz) {
        for (ServerModule sm : this.serverModules) {
            if (sm.getClass() != clazz) continue;
            return (T)sm;
        }
        return null;
    }
}

