/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.plugins;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.NodeRepresentation;
import org.neo4j.server.rest.repr.PathRepresentation;
import org.neo4j.server.rest.repr.RelationshipRepresentation;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationType;
import org.neo4j.server.rest.repr.ValueRepresentation;

abstract class ResultConverter {
    private static final ResultConverter IDENTITY_RESULT = new ResultConverter(){

        @Override
        Representation convert(Object obj) {
            return (Representation)obj;
        }

        @Override
        RepresentationType type() {
            return null;
        }
    };
    private static final ResultConverter NODE_RESULT = new ValueResult(RepresentationType.NODE){

        @Override
        Representation convert(Object obj) {
            return new NodeRepresentation((Node)obj);
        }
    };
    private static final ResultConverter RELATIONSHIP_RESULT = new ValueResult(RepresentationType.RELATIONSHIP){

        @Override
        Representation convert(Object obj) {
            return new RelationshipRepresentation((Relationship)obj);
        }
    };
    private static final ResultConverter PATH_RESULT = new ValueResult(RepresentationType.PATH){

        @Override
        Representation convert(Object obj) {
            return new PathRepresentation<Path>((Path)obj);
        }
    };
    private static final ResultConverter STRING_RESULT = new ValueResult(RepresentationType.STRING){

        @Override
        Representation convert(Object obj) {
            return ValueRepresentation.string((String)((String)obj));
        }
    };
    private static final ResultConverter LONG_RESULT = new ValueResult(RepresentationType.LONG){

        @Override
        Representation convert(Object obj) {
            return ValueRepresentation.number((long)((Number)obj).longValue());
        }
    };
    private static final ResultConverter DOUBLE_RESULT = new ValueResult(RepresentationType.DOUBLE){

        @Override
        Representation convert(Object obj) {
            return ValueRepresentation.number((double)((Number)obj).doubleValue());
        }
    };
    private static final ResultConverter BOOL_RESULT = new ValueResult(RepresentationType.BOOLEAN){

        @Override
        Representation convert(Object obj) {
            return ValueRepresentation.bool((boolean)((Boolean)obj));
        }
    };
    private static final ResultConverter INT_RESULT = new ValueResult(RepresentationType.INTEGER){

        @Override
        Representation convert(Object obj) {
            return ValueRepresentation.number((int)((Number)obj).intValue());
        }
    };
    private static final ResultConverter CHAR_RESULT = new ValueResult(RepresentationType.CHAR){

        @Override
        Representation convert(Object obj) {
            return ValueRepresentation.number((int)((Character)obj).charValue());
        }
    };
    private static final ResultConverter VOID_RESULT = new ValueResult(RepresentationType.NOTHING){

        @Override
        Representation convert(Object obj) {
            return Representation.emptyRepresentation();
        }
    };

    ResultConverter() {
    }

    static ResultConverter get(Type type) {
        return ResultConverter.get(type, true);
    }

    private static ResultConverter get(Type type, boolean allowComplex) {
        if (type instanceof Class) {
            Class cls = (Class)type;
            if (allowComplex && Representation.class.isAssignableFrom(cls)) {
                return IDENTITY_RESULT;
            }
            if (cls == Node.class) {
                return NODE_RESULT;
            }
            if (cls == Relationship.class) {
                return RELATIONSHIP_RESULT;
            }
            if (cls == Path.class) {
                return PATH_RESULT;
            }
            if (cls == String.class) {
                return STRING_RESULT;
            }
            if (cls == Void.TYPE || cls == Void.class) {
                return VOID_RESULT;
            }
            if (cls == Long.TYPE || cls == Long.class) {
                return LONG_RESULT;
            }
            if (cls == Double.TYPE || cls == Float.TYPE || cls == Double.class || cls == Float.class) {
                return DOUBLE_RESULT;
            }
            if (cls == Boolean.TYPE || cls == Boolean.class) {
                return BOOL_RESULT;
            }
            if (cls == Character.TYPE || cls == Character.class) {
                return CHAR_RESULT;
            }
            if (cls.isPrimitive() || Number.class.isAssignableFrom(cls) && cls.getPackage().getName().equals("java.lang")) {
                return INT_RESULT;
            }
        } else if (allowComplex && type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class raw = (Class)parameterizedType.getRawType();
            Type paramType = parameterizedType.getActualTypeArguments()[0];
            if (!(paramType instanceof Class)) {
                throw new IllegalStateException("Parameterized result types must have a concrete type parameter.");
            }
            Class param = (Class)paramType;
            if (Iterable.class.isAssignableFrom(raw)) {
                return new ListResult(ResultConverter.get(param, false));
            }
        }
        throw new IllegalStateException("Illegal result type: " + type);
    }

    abstract Representation convert(Object var1);

    abstract RepresentationType type();

    private static class ListResult
    extends ResultConverter {
        private final ResultConverter itemConverter;

        ListResult(ResultConverter itemConverter) {
            this.itemConverter = itemConverter;
        }

        @Override
        Representation convert(Object obj) {
            return new ListRepresentation(this.itemConverter.type(), (Iterable)new IterableWrapper<Representation, Object>((Iterable)obj){

                protected Representation underlyingObjectToObject(Object object) {
                    return ListResult.this.itemConverter.convert(object);
                }
            });
        }

        @Override
        RepresentationType type() {
            return null;
        }
    }

    private static abstract class ValueResult
    extends ResultConverter {
        private final RepresentationType type;

        ValueResult(RepresentationType type) {
            this.type = type;
        }

        @Override
        final RepresentationType type() {
            return this.type;
        }
    }
}

