/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.preflight;

import org.neo4j.server.logging.Logger;
import org.neo4j.server.preflight.PreflightTask;

public class PreFlightTasks {
    public static final Logger log = Logger.getLogger(PreFlightTasks.class);
    private final PreflightTask[] tasks;
    private PreflightTask failedTask = null;

    public PreFlightTasks(PreflightTask ... tasks) {
        this.tasks = tasks;
    }

    public boolean run() {
        if (this.tasks == null || this.tasks.length < 1) {
            return true;
        }
        for (PreflightTask r : this.tasks) {
            if (r.run()) continue;
            log.error(r.getFailureMessage(), new Object[0]);
            this.failedTask = r;
            return false;
        }
        return true;
    }

    public PreflightTask failedTask() {
        return this.failedTask;
    }
}

