/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.scripting.javascript;

import java.util.HashSet;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeJavaMethod;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.UniqueTag;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.server.scripting.UserScriptClassWhiteList;
import org.neo4j.server.scripting.javascript.WhiteListClassShutter;
import org.neo4j.server.scripting.javascript.WhiteListJavaWrapper;

public class TestWhiteListJavaWrapper {
    @After
    public void exitContext() {
        try {
            Context.exit();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test(expected=SecurityException.class)
    public void shouldBlockAttemptsAtAccessingClassLoader() throws Exception {
        WhiteListJavaWrapper wrapper = new WhiteListJavaWrapper((ClassShutter)new WhiteListClassShutter(new HashSet()));
        wrapper.wrap(null, null, (Object)this.getClass().getClassLoader(), null);
    }

    @Test
    public void shouldDownCastSubclassesToAllowedParentClass() throws Exception {
        HashSet<String> whiteList = new HashSet<String>();
        whiteList.add(Object.class.getName());
        WhiteListJavaWrapper wrapper = new WhiteListJavaWrapper((ClassShutter)new WhiteListClassShutter(whiteList));
        Context cx = Context.enter();
        ScriptableObject scope = cx.initStandardObjects();
        Object wrapped = wrapper.wrap(cx, (Scriptable)scope, (Object)new TestWhiteListJavaWrapper(), null);
        Assert.assertThat((Object)wrapped, (Matcher)Matchers.is(NativeJavaObject.class));
        NativeJavaObject obj = (NativeJavaObject)wrapped;
        Assert.assertThat((Object)obj.has("aGetter", (Scriptable)scope), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)((UniqueTag)obj.get("aGetter", (Scriptable)scope)), (Matcher)Matchers.is((Object)UniqueTag.NOT_FOUND));
    }

    @Test(expected=SecurityException.class)
    public void shouldThrowSecurityExceptionWhenAccessingLockedClasses() throws Exception {
        HashSet<String> whiteList = new HashSet<String>();
        whiteList.add(Object.class.getName());
        WhiteListJavaWrapper wrapper = new WhiteListJavaWrapper((ClassShutter)new WhiteListClassShutter(whiteList));
        Context cx = Context.enter();
        ScriptableObject scope = cx.initStandardObjects();
        Object wrapped = wrapper.wrap(cx, (Scriptable)scope, TestWhiteListJavaWrapper.class, null);
    }

    @Test
    public void shouldAllowAccessToWhiteListedClassMembers() throws Exception {
        WhiteListJavaWrapper wrapper = new WhiteListJavaWrapper((ClassShutter)new WhiteListClassShutter(UserScriptClassWhiteList.getWhiteList()));
        Context cx = Context.enter();
        ScriptableObject scope = cx.initStandardObjects();
        Object wrapped = wrapper.wrap(cx, (Scriptable)scope, (Object)DynamicRelationshipType.withName((String)"blah"), null);
        Assert.assertThat((Object)wrapped, (Matcher)Matchers.is(NativeJavaObject.class));
        NativeJavaObject obj = (NativeJavaObject)wrapped;
        Assert.assertThat((Object)obj.get("name", (Scriptable)scope), (Matcher)Matchers.is(NativeJavaMethod.class));
    }

    public void aGetter() {
    }
}

