/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webadmin.rest;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.SystemConfiguration;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.server.database.Database;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.formats.JsonFormat;
import org.neo4j.server.rrd.JobScheduler;
import org.neo4j.server.rrd.RrdFactory;
import org.neo4j.server.webadmin.rest.MonitorService;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.neo4j.test.server.EntityOutputFormat;
import org.rrd4j.core.RrdDb;

public class MonitorServiceTest
implements JobScheduler {
    private RrdDb rrdDb;
    private MonitorService monitorService;
    private Database database;
    private EntityOutputFormat output;

    @Test
    public void correctRepresentation() throws Exception {
        Response resp = this.monitorService.getServiceDefinition();
        Assert.assertEquals((long)200L, (long)resp.getStatus());
        Map<String, Object> resultAsMap = this.output.getResultAsMap();
        Map resources = (Map)resultAsMap.get("resources");
        MatcherAssert.assertThat((Object)((String)resources.get("data_from")), (Matcher)Matchers.containsString((String)"/fetch/{start}"));
        MatcherAssert.assertThat((Object)((String)resources.get("data_period")), (Matcher)Matchers.containsString((String)"/fetch/{start}/{stop}"));
        String latest_data = (String)resources.get("latest_data");
        MatcherAssert.assertThat((Object)latest_data, (Matcher)Matchers.containsString((String)"/fetch"));
    }

    @Test
    public void canFetchData() throws URISyntaxException, UnsupportedEncodingException {
        UriInfo mockUri = (UriInfo)Mockito.mock(UriInfo.class);
        URI uri = new URI("http://peteriscool.com:6666/");
        Mockito.when((Object)mockUri.getBaseUri()).thenReturn((Object)uri);
        Response resp = this.monitorService.getData();
        String entity = new String((byte[])resp.getEntity(), "UTF-8");
        Assert.assertEquals((String)entity, (long)200L, (long)resp.getStatus());
        MatcherAssert.assertThat((Object)entity, (Matcher)Matchers.containsString((String)"timestamps"));
        MatcherAssert.assertThat((Object)entity, (Matcher)Matchers.containsString((String)"end_time"));
        MatcherAssert.assertThat((Object)entity, (Matcher)Matchers.containsString((String)"property_count"));
    }

    @Before
    public void setUp() throws Exception {
        this.database = new Database((AbstractGraphDatabase)new ImpermanentGraphDatabase());
        this.rrdDb = new RrdFactory((Configuration)new SystemConfiguration()).createRrdDbAndSampler(this.database, (JobScheduler)this);
        this.output = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), URI.create("http://peteriscool.com:6666/"), null);
        this.monitorService = new MonitorService(this.rrdDb, (OutputFormat)this.output);
    }

    @After
    public void shutdownDatabase() throws Throwable {
        try {
            this.rrdDb.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.database.shutdown();
    }

    public void scheduleAtFixedRate(Runnable job, String jobName, long delay, long period) {
    }
}

