/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.logging;

import java.util.logging.Level;

public class Logger {
    java.util.logging.Logger logger;

    public static Logger getLogger(Class<?> clazz) {
        return new Logger(clazz);
    }

    public static Logger getLogger(String logger) {
        return new Logger(logger);
    }

    public Logger(Class<?> clazz) {
        this(clazz.getCanonicalName());
    }

    public Logger(String str) {
        this.logger = java.util.logging.Logger.getLogger(str);
    }

    public void log(Level priority, String message, Throwable throwable) {
        this.logger.log(priority, message, throwable);
    }

    public void log(Level level, String message, Object ... parameters) {
        String logMessage = String.format(message, parameters);
        if (this.logger != null) {
            if (this.logger.isLoggable(level)) {
                this.logger.log(level, logMessage);
            }
        } else {
            System.out.println(String.format("Logger not configured, logging to std out instead: [%s] %s", level.getName(), logMessage));
        }
    }

    public void fatal(String message, Object ... parameters) {
        this.log(Level.SEVERE, message, parameters);
    }

    public void error(String message, Object ... parameters) {
        this.log(Level.SEVERE, message, parameters);
    }

    public void error(Throwable e) {
        this.log(Level.SEVERE, "", e);
    }

    public void warn(Throwable e) {
        this.log(Level.WARNING, "", e);
    }

    public void warn(String message, Object ... parameters) {
        this.log(Level.WARNING, message, parameters);
    }

    public void info(String message, Object ... parameters) {
        this.log(Level.INFO, message, parameters);
    }

    public void debug(String message, Object ... parameters) {
        this.log(Level.FINE, message, parameters);
    }

    public void trace(String message, Object ... parameters) {
        this.log(Level.FINEST, message, parameters);
    }
}

