/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.net.URI;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.modules.RESTApiModule;
import org.neo4j.server.web.WebServer;

public class RESTApiModuleTest {
    @Test
    public void shouldRegisterASingleUri() throws Exception {
        WebServer webServer = (WebServer)Mockito.mock(WebServer.class);
        CommunityNeoServer neoServer = (CommunityNeoServer)Mockito.mock(CommunityNeoServer.class);
        Mockito.when((Object)neoServer.baseUri()).thenReturn((Object)new URI("http://localhost:7575"));
        Mockito.when((Object)neoServer.getWebServer()).thenReturn((Object)webServer);
        PropertiesConfiguration config = new PropertiesConfiguration();
        String path = "/db/data";
        config.addProperty("org.neo4j.server.webadmin.data.uri", (Object)path);
        Mockito.when((Object)neoServer.getConfiguration()).thenReturn((Object)config);
        RESTApiModule module = new RESTApiModule(webServer, neoServer.getDatabase(), (Configuration)config);
        module.start(StringLogger.DEV_NULL);
        ((WebServer)Mockito.verify((Object)webServer)).addJAXRSPackages((List)Matchers.any(List.class), Matchers.anyString(), Matchers.anyCollection());
    }
}

