/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webadmin;

import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.webadmin.AbstractWebadminTest;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;

public class ConsoleWebIT
extends AbstractWebadminTest {
    @Test
    @Documented(value=" In order to access the Shell console,\n click on the \"Console\" tab in the webadmin\n and check the \"Shell\" link.\n \n @@screenshot_ShellConsole\n")
    public void accessing_the_Shell_console() {
        wl.goToWebadminStartPage();
        wl.clickOnTab("Console");
        wl.clickOnLink("Neo4j Shell");
        wl.waitForElementToAppear(By.xpath((String)"//ul/li[contains(.,'neo4j-sh')]"));
        this.captureScreenshot("screenshot_ShellConsole");
    }

    @Test
    public void remembersShellStateWhenSwitchingTabsTest() {
        wl.goToWebadminStartPage();
        wl.clickOnTab("Console");
        wl.clickOnLink("HTTP");
        wl.clickOnTab("Data browser");
        wl.clickOnTab("Console");
        wl.waitForElementToAppear(By.xpath((String)"//li[contains(.,'200')]"));
    }

    @Test
    @Ignore(value="Broken due to http://code.google.com/p/selenium/issues/detail?id=1723")
    public void cypherHasMultilineInput() {
        this.accessing_the_Shell_console();
        wl.writeTo(By.id((String)"console-input"), new CharSequence[]{"start a=node(1)", Keys.RETURN});
        wl.writeTo(By.id((String)"console-input"), new CharSequence[]{"return a", Keys.RETURN});
        wl.writeTo(By.id((String)"console-input"), new CharSequence[]{Keys.RETURN});
        wl.waitForElementToAppear(By.xpath((String)"//li[contains(.,'Node[0]')]"));
    }

    @Test
    public void hasHttpConsoleTest() {
        wl.goToWebadminStartPage();
        wl.clickOnTab("Console");
        wl.clickOnLink("HTTP");
        wl.waitForElementToAppear(By.xpath((String)"//p[contains(.,'HTTP Console')]"));
    }

    @Test
    public void canAccessServerViaHttpConsoleTest() {
        wl.goToWebadminStartPage();
        wl.clickOnTab("Console");
        wl.clickOnLink("HTTP");
        wl.writeTo(By.id((String)"console-input"), new CharSequence[]{"GET /db/data/", Keys.RETURN});
        wl.waitForElementToAppear(By.xpath((String)"//li[contains(.,'200')]"));
    }

    @Test
    public void httpConsoleShows404ProperlyTest() {
        wl.goToWebadminStartPage();
        wl.clickOnTab("Console");
        wl.clickOnLink("HTTP");
        wl.writeTo(By.id((String)"console-input"), new CharSequence[]{"GET /asd/ads/", Keys.RETURN});
        wl.waitForElementToAppear(By.xpath((String)"//li[contains(.,'404')]"));
    }

    @Test
    public void httpConsoleShowsSyntaxErrorsTest() {
        wl.goToWebadminStartPage();
        wl.clickOnTab("Console");
        wl.clickOnLink("HTTP");
        wl.writeTo(By.id((String)"console-input"), new CharSequence[]{"blus 12 blah blah", Keys.RETURN});
        wl.waitForElementToAppear(By.xpath((String)"//li[contains(.,'Invalid')]"));
    }

    @Test
    public void httpConsoleShowsJSONErrorsTest() {
        wl.goToWebadminStartPage();
        wl.clickOnTab("Console");
        wl.clickOnLink("HTTP");
        wl.writeTo(By.id((String)"console-input"), new CharSequence[]{"POST / {blah}", Keys.RETURN});
        wl.waitForElementToAppear(By.xpath((String)"//li[contains(.,'Invalid')]"));
    }
}

