/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.helpers.ServerBuilder;
import org.neo4j.server.statistic.StatisticRecord;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class StatisticsCollectionEnabledDocIT
extends ExclusiveServerTestBase {
    private CommunityNeoServer server;

    @After
    public void stopTheServer() {
        this.server.stop();
    }

    @Test
    public void statisticsShouldBeDisabledByDefault() throws Exception {
        this.server = ServerBuilder.server().usingDatabaseDir(this.folder.getRoot().getAbsolutePath()).build();
        this.server.start();
        Client.create().resource(this.server.baseUri()).get(ClientResponse.class);
        StatisticRecord snapshot = this.server.statisticsCollector.createSnapshot();
        Assert.assertThat((Object)snapshot.getRequests(), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void statisticsCouldBeEnabled() throws Exception {
        this.server = ServerBuilder.server().withProperty("org.neo4j.server.webserver.statistics", "true").usingDatabaseDir(this.folder.getRoot().getAbsolutePath()).build();
        this.server.start();
        Client.create().resource(this.server.baseUri()).get(ClientResponse.class);
        StatisticRecord snapshot = this.server.statisticsCollector.createSnapshot();
        Assert.assertThat((Object)snapshot.getRequests(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
    }
}

