/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rrd;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.Configuration;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.server.database.Database;
import org.neo4j.server.logging.Logger;
import org.neo4j.server.rrd.JobScheduler;
import org.neo4j.server.rrd.RrdJob;
import org.neo4j.server.rrd.RrdSamplerImpl;
import org.neo4j.server.rrd.Sampleable;
import org.neo4j.server.rrd.sampler.NodeIdsInUseSampleable;
import org.neo4j.server.rrd.sampler.PropertyCountSampleable;
import org.neo4j.server.rrd.sampler.RelationshipCountSampleable;
import org.rrd4j.ConsolFun;
import org.rrd4j.core.DsDef;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.RrdToolkit;

public class RrdFactory {
    public static final int STEP_SIZE = 1;
    private static final String RRD_THREAD_NAME = "Statistics Gatherer";
    private final Configuration config;
    private static final Logger LOG = Logger.getLogger(RrdFactory.class);

    public RrdFactory(Configuration config) {
        this.config = config;
    }

    public RrdDb createRrdDbAndSampler(Database db, JobScheduler scheduler) throws IOException {
        Sampleable[] primitives = new Sampleable[]{new NodeIdsInUseSampleable(db.getGraph()), new PropertyCountSampleable(db.getGraph()), new RelationshipCountSampleable(db.getGraph())};
        Sampleable[] usage = new Sampleable[]{};
        String basePath = this.config.getString("org.neo4j.server.webadmin.rrdb.location", this.getDefaultDirectory(db.getGraph()));
        RrdDb rrdb = this.createRrdb(basePath, this.join(primitives, usage));
        scheduler.scheduleAtFixedRate(new RrdJob(new RrdSamplerImpl(rrdb, primitives)), "Statistics Gatherer[primitives]", TimeUnit.SECONDS.toMillis(0L), TimeUnit.SECONDS.toMillis(3L));
        return rrdb;
    }

    private Sampleable[] join(Sampleable[] ... sampleables) {
        ArrayList result = new ArrayList();
        for (Sampleable[] sampleable : sampleables) {
            Collections.addAll(result, sampleable);
        }
        return result.toArray(new Sampleable[result.size()]);
    }

    private String getDefaultDirectory(GraphDatabaseAPI db) throws IOException {
        if (this.isEphemereal(db)) {
            return this.tempDir();
        }
        return new File(db.getStoreDir(), "rrd").getAbsolutePath();
    }

    protected String tempDir() throws IOException {
        File tempFile = File.createTempFile("neo4j", "rrd");
        tempFile.delete();
        tempFile.mkdir();
        tempFile.deleteOnExit();
        return tempFile.getAbsolutePath();
    }

    private boolean isEphemereal(GraphDatabaseAPI db) {
        Config config = (Config)db.getDependencyResolver().resolveDependency(Config.class);
        if (config == null) {
            return false;
        }
        Boolean aBoolean = (Boolean)config.get(InternalAbstractGraphDatabase.Configuration.ephemeral);
        return aBoolean != null && aBoolean != false;
    }

    protected RrdDb createRrdb(String rrdPathx, Sampleable ... sampleables) {
        File rrdFile = new File(rrdPathx);
        if (rrdFile.exists()) {
            try {
                if (!this.validateStepSize(rrdFile)) {
                    return this.recreateArchive(rrdFile, sampleables);
                }
                Sampleable[] missing = RrdFactory.checkDataSources(rrdFile.getAbsolutePath(), sampleables);
                if (missing.length > 0) {
                    RrdFactory.updateDataSources(rrdFile.getAbsolutePath(), missing);
                }
                return new RrdDb(rrdFile.getAbsolutePath());
            }
            catch (IOException e) {
                LOG.error("Unable to open rrd store, attempting to recreate it", e);
                return this.recreateArchive(rrdFile, sampleables);
            }
            catch (IllegalArgumentException e) {
                LOG.error("Unable to open rrd store, attempting to recreate it", e);
                return this.recreateArchive(rrdFile, sampleables);
            }
        }
        RrdDef rrdDef = new RrdDef(rrdFile.getAbsolutePath(), 1L);
        this.defineDataSources(rrdDef, sampleables);
        this.addArchives(rrdDef);
        try {
            return new RrdDb(rrdDef);
        }
        catch (IOException e) {
            LOG.error("Unable to create new rrd store", e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateStepSize(File rrdFile) throws IOException {
        RrdDb r = null;
        try {
            r = new RrdDb(rrdFile.getAbsolutePath(), true);
            boolean bl = r.getRrdDef().getStep() == 1L;
            return bl;
        }
        finally {
            if (r != null) {
                r.close();
            }
        }
    }

    private RrdDb recreateArchive(File rrdFile, Sampleable[] sampleables) {
        File file = new File(rrdFile.getParentFile(), rrdFile.getName() + "-invalid-" + System.currentTimeMillis());
        if (rrdFile.renameTo(file)) {
            LOG.error("current RRDB is invalid, renamed it to %s", file.getAbsolutePath());
            return this.createRrdb(rrdFile.getAbsolutePath(), sampleables);
        }
        throw new RuntimeException("RRD file ['" + rrdFile.getAbsolutePath() + "'] is invalid, but I do not have write permissions to recreate it.");
    }

    private static Sampleable[] checkDataSources(String rrdPath, Sampleable[] sampleables) throws IOException {
        RrdDb rrdDb = new RrdDb(rrdPath, true);
        ArrayList<Sampleable> missing = new ArrayList<Sampleable>();
        for (Sampleable sampleable : sampleables) {
            if (rrdDb.getDatasource(sampleable.getName()) != null) continue;
            missing.add(sampleable);
        }
        rrdDb.close();
        return missing.toArray(new Sampleable[missing.size()]);
    }

    private static void updateDataSources(String rrdPath, Sampleable[] sampleables) throws IOException {
        for (Sampleable sampleable : sampleables) {
            LOG.warn("Updating RRDB structure, adding: " + sampleable.getName(), new Object[0]);
            RrdToolkit.addDatasource((String)rrdPath, (DsDef)RrdFactory.createDsDef(sampleable), (boolean)true);
        }
    }

    private static DsDef createDsDef(Sampleable sampleable) {
        return new DsDef(sampleable.getName(), sampleable.getType(), 120L, Double.NaN, Double.NaN);
    }

    private void addArchives(RrdDef rrdDef) {
        for (ConsolFun fun : Arrays.asList(ConsolFun.AVERAGE, ConsolFun.MAX, ConsolFun.MIN)) {
            this.addArchive(rrdDef, fun, TimeUnit.MINUTES.toSeconds(30L), TimeUnit.SECONDS.toSeconds(1L));
            this.addArchive(rrdDef, fun, TimeUnit.DAYS.toSeconds(1L), TimeUnit.MINUTES.toSeconds(1L));
            this.addArchive(rrdDef, fun, TimeUnit.DAYS.toSeconds(7L), TimeUnit.MINUTES.toSeconds(5L));
            this.addArchive(rrdDef, fun, TimeUnit.DAYS.toSeconds(30L), TimeUnit.MINUTES.toSeconds(30L));
            this.addArchive(rrdDef, fun, TimeUnit.DAYS.toSeconds(1780L), TimeUnit.HOURS.toSeconds(2L));
        }
    }

    private void addArchive(RrdDef rrdDef, ConsolFun fun, long length, long resolution) {
        rrdDef.addArchive(fun, 0.2, (int)(resolution * 1L), (int)(length / (resolution * 1L)));
    }

    private void defineDataSources(RrdDef rrdDef, Sampleable[] sampleables) {
        for (Sampleable sampleable : sampleables) {
            rrdDef.addDatasource(RrdFactory.createDsDef(sampleable));
        }
    }
}

