/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.logging;

import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.neo4j.server.logging.Logger;

public class InMemoryAppender {
    private StringWriter stringWriter = new StringWriter();
    private Handler stringHandler;
    private final java.util.logging.Logger julLogger;
    private final Level level;

    public InMemoryAppender(Logger logger) {
        this(logger, Level.ALL);
    }

    private InMemoryAppender(Logger logger, Level level) {
        this.level = level;
        this.julLogger = java.util.logging.Logger.getLogger(this.getClass().toString());
        this.changeLogger(logger, this.julLogger);
        this.reset();
    }

    private void changeLogger(Logger logger, java.util.logging.Logger julLogger) {
        Field loggerField = this.findLoggerField(logger);
        try {
            loggerField.setAccessible(true);
            loggerField.set(logger, julLogger);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Field findLoggerField(Logger logger) {
        try {
            return logger.getClass().getDeclaredField("logger");
        }
        catch (Exception e) {
            throw new RuntimeException("The field [logger] must be present for testing", e);
        }
    }

    public String toString() {
        return this.stringWriter.toString();
    }

    public void reset() {
        this.stringWriter = new StringWriter();
        this.stringHandler = new Handler(){

            @Override
            public void publish(LogRecord record) {
                InMemoryAppender.this.stringWriter.append(this.getFormatter().format(record));
            }

            @Override
            public void close() throws SecurityException {
            }

            @Override
            public void flush() {
            }
        };
        this.stringHandler.setFormatter(new SimpleFormatter());
        this.julLogger.addHandler(this.stringHandler);
        this.julLogger.setLevel(this.level);
    }
}

