/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.io.IOException;
import java.util.Collections;
import javax.ws.rs.core.MediaType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RESTDocsGenerator;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.web.PropertyValueException;

public class GetNodePropertiesDocIT
extends AbstractRestFunctionalTestBase {
    private static FunctionalTestHelper functionalTestHelper;
    private RestRequest req;

    @BeforeClass
    public static void setupServer() throws IOException {
        functionalTestHelper = new FunctionalTestHelper(GetNodePropertiesDocIT.server());
    }

    @Before
    public void cleanTheDatabase() {
        this.cleanDatabase();
        this.req = RestRequest.req();
    }

    @Documented(value=" Get properties for node (empty result).\n \n If there are no properties, there will be an HTTP 204 response.\n")
    @Test
    public void shouldGet204ForNoProperties() {
        JaxRsResponse createResponse = this.req.post(functionalTestHelper.dataUri() + "node/", "");
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(204).get(createResponse.getLocation().toString() + "/properties");
    }

    @Documented(value=" Get properties for node.\n")
    @Test
    public void shouldGet200ForProperties() throws JsonParseException {
        String entity = JsonHelper.createJsonFrom(Collections.singletonMap("foo", "bar"));
        JaxRsResponse createResponse = this.req.post(functionalTestHelper.dataUri() + "node/", entity);
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(200).get(createResponse.getLocation().toString() + "/properties");
    }

    @Test
    public void shouldGetContentLengthHeaderForRetrievingProperties() throws JsonParseException {
        String entity = JsonHelper.createJsonFrom(Collections.singletonMap("foo", "bar"));
        RestRequest request = this.req;
        JaxRsResponse createResponse = request.post(functionalTestHelper.dataUri() + "node/", entity);
        JaxRsResponse response = request.get(createResponse.getLocation().toString() + "/properties");
        Assert.assertNotNull((Object)response.getHeaders().get((Object)"Content-Length"));
    }

    @Test
    public void shouldGetCorrectContentEncodingRetrievingProperties() throws PropertyValueException {
        String asianText = "\u4f8b\u5b50";
        String germanText = "\u00f6\u00e4\u00fc\u00d6\u00c4\u00dc\u00df";
        String complicatedString = asianText + germanText;
        String entity = JsonHelper.createJsonFrom(Collections.singletonMap("foo", complicatedString));
        RestRequest request = this.req;
        JaxRsResponse createResponse = request.post(functionalTestHelper.dataUri() + "node/", entity);
        String response = (String)JsonHelper.jsonToSingleValue((String)request.get(this.getPropertyUri(createResponse.getLocation().toString(), "foo")).getEntity());
        Assert.assertEquals((Object)complicatedString, (Object)response);
    }

    @Test
    public void shouldGetCorrectContentEncodingRetrievingPropertiesWithStreaming() throws PropertyValueException {
        String asianText = "\u4f8b\u5b50";
        String germanText = "\u00f6\u00e4\u00fc\u00d6\u00c4\u00dc\u00df";
        String complicatedString = asianText + germanText;
        String entity = JsonHelper.createJsonFrom(Collections.singletonMap("foo", complicatedString));
        RestRequest request = this.req.header("X-Stream", "true");
        JaxRsResponse createResponse = request.post(functionalTestHelper.dataUri() + "node/", entity);
        String response = (String)JsonHelper.jsonToSingleValue((String)request.get(this.getPropertyUri(createResponse.getLocation().toString(), "foo"), new MediaType("application", "json", MapUtil.stringMap((String[])new String[]{"stream", "true"}))).getEntity());
        Assert.assertEquals((Object)complicatedString, (Object)response);
    }

    @Test
    public void shouldGet404ForPropertiesOnNonExistentNode() {
        JaxRsResponse response = RestRequest.req().get(functionalTestHelper.dataUri() + "node/999999/properties");
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void shouldBeJSONContentTypeOnPropertiesResponse() throws JsonParseException {
        String entity = JsonHelper.createJsonFrom(Collections.singletonMap("foo", "bar"));
        JaxRsResponse createResource = this.req.post(functionalTestHelper.dataUri() + "node/", entity);
        JaxRsResponse response = this.req.get(createResource.getLocation().toString() + "/properties");
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
    }

    @Test
    public void shouldGet404ForNoProperty() {
        JaxRsResponse createResponse = this.req.post(functionalTestHelper.dataUri() + "node/", "");
        JaxRsResponse response = this.req.get(this.getPropertyUri(createResponse.getLocation().toString(), "foo"));
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Documented(value=" Get property for node.\n \n Get a single node property from a node.\n")
    @Test
    public void shouldGet200ForProperty() throws JsonParseException {
        String entity = JsonHelper.createJsonFrom(Collections.singletonMap("foo", "bar"));
        JaxRsResponse createResponse = this.req.post(functionalTestHelper.dataUri() + "node/", entity);
        JaxRsResponse response = this.req.get(this.getPropertyUri(createResponse.getLocation().toString(), "foo"));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(200).get(this.getPropertyUri(createResponse.getLocation().toString(), "foo"));
    }

    @Test
    public void shouldGet404ForPropertyOnNonExistentNode() {
        JaxRsResponse response = RestRequest.req().get(this.getPropertyUri(functionalTestHelper.dataUri() + "node/" + "999999", "foo"));
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void shouldBeJSONContentTypeOnPropertyResponse() throws JsonParseException {
        String entity = JsonHelper.createJsonFrom(Collections.singletonMap("foo", "bar"));
        JaxRsResponse createResponse = this.req.post(functionalTestHelper.dataUri() + "node/", entity);
        JaxRsResponse response = this.req.get(this.getPropertyUri(createResponse.getLocation().toString(), "foo"));
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        createResponse.close();
        response.close();
    }

    private String getPropertyUri(String baseUri, String key) {
        return baseUri + "/properties/" + key;
    }
}

