/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.util.Collections;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.Node;
import org.neo4j.server.rest.repr.BadInputException;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.NodeRepresentation;
import org.neo4j.server.rest.repr.RepresentationTestAccess;
import org.neo4j.server.rest.repr.RepresentationTestBase;

public class NodeRepresentationTest {
    @Test
    public void shouldHaveSelfLink() throws BadInputException {
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern(""), this.noderep(1234L).selfUri());
    }

    @Test
    public void shouldHaveAllRelationshipsLink() throws BadInputException {
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/relationships/all"), this.noderep(1234L).allRelationshipsUri());
    }

    @Test
    public void shouldHaveIncomingRelationshipsLink() throws BadInputException {
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/relationships/in"), this.noderep(1234L).incomingRelationshipsUri());
    }

    @Test
    public void shouldHaveOutgoingRelationshipsLink() throws BadInputException {
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/relationships/out"), this.noderep(1234L).outgoingRelationshipsUri());
    }

    @Test
    public void shouldHaveAllTypedRelationshipsLinkTemplate() throws BadInputException {
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/relationships/all/\\{-list\\|&\\|types\\}"), this.noderep(1234L).allTypedRelationshipsUriTemplate());
    }

    @Test
    public void shouldHaveIncomingTypedRelationshipsLinkTemplate() throws BadInputException {
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/relationships/in/\\{-list\\|&\\|types\\}"), this.noderep(1234L).incomingTypedRelationshipsUriTemplate());
    }

    @Test
    public void shouldHaveOutgoingTypedRelationshipsLinkTemplate() throws BadInputException {
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/relationships/out/\\{-list\\|&\\|types\\}"), this.noderep(1234L).outgoingTypedRelationshipsUriTemplate());
    }

    @Test
    public void shouldHaveRelationshipCreationLink() throws BadInputException {
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/relationships"), this.noderep(1234L).relationshipCreationUri());
    }

    @Test
    public void shouldHavePropertiesLink() throws BadInputException {
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/properties"), this.noderep(1234L).propertiesUri());
    }

    @Test
    public void shouldHavePropertyLinkTemplate() throws BadInputException {
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/properties/\\{key\\}"), this.noderep(1234L).propertyUriTemplate());
    }

    @Test
    public void shouldHaveTraverseLinkTemplate() throws BadInputException {
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/traverse/\\{returnType\\}"), this.noderep(1234L).traverseUriTemplate());
    }

    @Test
    public void shouldSerialiseToMap() {
        Map<String, Object> repr = RepresentationTestAccess.serialize((MappingRepresentation)this.noderep(1234L));
        Assert.assertNotNull(repr);
        NodeRepresentationTest.verifySerialisation(repr);
    }

    private NodeRepresentation noderep(long id) {
        return new NodeRepresentation(this.node(id));
    }

    private Node node(long id) {
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)node.getId()).thenReturn((Object)id);
        Mockito.when((Object)node.getPropertyKeys()).thenReturn(Collections.emptySet());
        return node;
    }

    public static void verifySerialisation(Map<String, Object> noderep) {
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern(""), noderep.get("self").toString());
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/relationships"), noderep.get("create_relationship").toString());
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/relationships/all"), noderep.get("all_relationships").toString());
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/relationships/in"), noderep.get("incoming_relationships").toString());
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/relationships/out"), noderep.get("outgoing_relationships").toString());
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/relationships/all/\\{-list\\|&\\|types\\}"), (String)noderep.get("all_typed_relationships"));
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/relationships/in/\\{-list\\|&\\|types\\}"), (String)noderep.get("incoming_typed_relationships"));
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/relationships/out/\\{-list\\|&\\|types\\}"), (String)noderep.get("outgoing_typed_relationships"));
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/properties"), noderep.get("properties").toString());
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/properties/\\{key\\}"), (String)noderep.get("property"));
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/traverse/\\{returnType\\}"), (String)noderep.get("traverse"));
        Assert.assertNotNull((Object)noderep.get("data"));
    }
}

