/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.ListSerializer;
import org.neo4j.server.rest.repr.ListWriter;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.rest.repr.MappingWriter;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.ValueRepresentation;
import org.neo4j.server.rest.repr.formats.ListWrappingWriter;
import org.neo4j.server.rest.repr.formats.MapWrappingWriter;

public class RepresentationTestAccess {
    private static final URI BASE_URI = URI.create("http://neo4j.org/");

    public static Object serialize(Representation repr) {
        if (repr instanceof ValueRepresentation) {
            return RepresentationTestAccess.serialize((ValueRepresentation)repr);
        }
        if (repr instanceof MappingRepresentation) {
            return RepresentationTestAccess.serialize((MappingRepresentation)repr);
        }
        if (repr instanceof ListRepresentation) {
            return RepresentationTestAccess.serialize((ListRepresentation)repr);
        }
        throw new IllegalArgumentException(repr.getClass().toString());
    }

    public static String serialize(ValueRepresentation repr) {
        return RepresentationTestAccess.serialize(BASE_URI, repr);
    }

    public static String serialize(URI baseUri, ValueRepresentation repr) {
        return repr.serialize((RepresentationFormat)new StringFormat(), baseUri, null);
    }

    public static Map<String, Object> serialize(MappingRepresentation repr) {
        return RepresentationTestAccess.serialize(BASE_URI, repr);
    }

    public static Map<String, Object> serialize(URI baseUri, MappingRepresentation repr) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        repr.serialize(new MappingSerializer((MappingWriter)new MapWrappingWriter(result), baseUri, null));
        return result;
    }

    public static List<Object> serialize(ListRepresentation repr) {
        return RepresentationTestAccess.serialize(BASE_URI, repr);
    }

    public static List<Object> serialize(URI baseUri, ListRepresentation repr) {
        ArrayList<Object> result = new ArrayList<Object>();
        repr.serialize(new ListSerializer((ListWriter)new ListWrappingWriter(result), baseUri, null));
        return result;
    }

    private static class StringFormat
    extends RepresentationFormat {
        StringFormat() {
            super(MediaType.WILDCARD_TYPE);
        }

        protected String serializeValue(String type, Object value) {
            return value.toString();
        }

        protected String complete(ListWriter serializer) {
            throw new UnsupportedOperationException("StringFormat.complete(ListWriter)");
        }

        protected String complete(MappingWriter serializer) {
            throw new UnsupportedOperationException("StringFormat.complete(MappingWriter)");
        }

        protected ListWriter serializeList(String type) {
            throw new UnsupportedOperationException("StringFormat.serializeList()");
        }

        protected MappingWriter serializeMapping(String type) {
            throw new UnsupportedOperationException("StringFormat.serializeMapping()");
        }

        public List<Object> readList(String input) {
            throw new UnsupportedOperationException("StringFormat.readList()");
        }

        public Map<String, Object> readMap(String input, String ... requiredKeys) {
            throw new UnsupportedOperationException("StringFormat.readMap()");
        }

        public Object readValue(String input) {
            throw new UnsupportedOperationException("StringFormat.readValue()");
        }

        public URI readUri(String input) {
            throw new UnsupportedOperationException("StringFormat.readUri()");
        }
    }
}

