/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr.formats;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.server.WrappingNeoServer;
import org.neo4j.test.ImpermanentGraphDatabase;

@Ignore
public class StreamingJsonFormatPerformanceTest {
    public static final String QUERY = "start n=node(*) match p=n-[r:TYPE]->m return n,r,m,p";
    private ImpermanentGraphDatabase gdb;
    private WrappingNeoServer server;

    @Before
    public void setUp() {
        this.gdb = new ImpermanentGraphDatabase();
        for (int i = 0; i < 10; ++i) {
            this.createData();
        }
        this.server = new WrappingNeoServer((GraphDatabaseAPI)this.gdb);
        this.server.start();
    }

    @After
    public void tearDown() throws Exception {
        this.server.stop();
    }

    @Test
    public void testStreamCypherResults() throws Exception {
        String query = "{\"query\":\"start n=node(*) match p=n-[r:TYPE]->m return n,r,m,p\"}";
        this.measureQueryTime("{\"query\":\"start n=node(*) match p=n-[r:TYPE]->m return n,r,m,p\"}");
    }

    private long measureQueryTime(String query) throws IOException {
        URI baseUri = this.server.baseUri();
        URL url = new URL(baseUri.toURL(), "db/data/cypher");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setInstanceFollowRedirects(false);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("Accept", "application/json; stream=true");
        OutputStream os = connection.getOutputStream();
        os.write(query.getBytes());
        os.close();
        BufferedInputStream input = new BufferedInputStream(connection.getInputStream());
        long time = System.currentTimeMillis();
        while (((InputStream)input).read() != -1) {
        }
        ((InputStream)input).close();
        long delta = System.currentTimeMillis() - time;
        System.out.println(" took " + delta + " ms.");
        return delta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createData() {
        Transaction tx = this.gdb.beginTx();
        try {
            DynamicRelationshipType TYPE = DynamicRelationshipType.withName((String)"TYPE");
            Node last = this.gdb.getReferenceNode();
            last.setProperty("id", (Object)0);
            for (int i = 1; i < 10000; ++i) {
                Node node = this.gdb.createNode();
                last.setProperty("id", (Object)i);
                node.createRelationshipTo(last, (RelationshipType)TYPE);
                last = node;
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
    }
}

