/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.security;

import java.net.URI;
import javax.ws.rs.core.MediaType;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.NeoServer;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.helpers.ServerBuilder;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RESTDocsGenerator;
import org.neo4j.server.rest.security.PermanentlyFailingSecurityRule;
import org.neo4j.server.rest.security.PermanentlyFailingSecurityRuleWithComplexWildcardPath;
import org.neo4j.server.rest.security.PermanentlyFailingSecurityRuleWithWildcardPath;
import org.neo4j.server.rest.security.PermanentlyPassingSecurityRule;
import org.neo4j.test.TestData;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class SecurityRulesDocIT
extends ExclusiveServerTestBase {
    private CommunityNeoServer server;
    private FunctionalTestHelper functionalTestHelper;
    @Rule
    public TestData<RESTDocsGenerator> gen = TestData.producedThrough(RESTDocsGenerator.PRODUCER);

    @After
    public void stopServer() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Test
    @Documented(value=" In this example, a (dummy) failing security rule is registered to deny\n access to all URIs to the server by listing the rules class in\n 'neo4j-server.properties':\n\n @@config\n \n with the rule source code of:\n \n @@failingRule\n \n With this rule registered, any access to the server will be\n denied. In a production-quality implementation the rule\n will likely lookup credentials/claims in a 3rd-party\n directory service (e.g. LDAP) or in a local database of\n authorized users.\n")
    @TestData.Title(value="Enforcing Server Authorization Rules")
    public void should401WithBasicChallengeWhenASecurityRuleFails() throws Exception {
        this.server = ServerBuilder.server().withDefaultDatabaseTuning().withSecurityRules(PermanentlyFailingSecurityRule.class.getCanonicalName()).usingDatabaseDir(this.folder.getRoot().getAbsolutePath()).build();
        this.server.start();
        ((RESTDocsGenerator)((Object)this.gen.get())).addSnippet("config", "\n[source]\n----\norg.neo4j.server.rest.security_rules=my.rules.PermanentlyFailingSecurityRule\n----\n");
        ((RESTDocsGenerator)((Object)this.gen.get())).addTestSourceSnippets(PermanentlyFailingSecurityRule.class, new String[]{"failingRule"});
        this.functionalTestHelper = new FunctionalTestHelper((NeoServer)this.server);
        ((RESTDocsGenerator)((Object)this.gen.get())).setSection("ops");
        JaxRsResponse response = ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(401).expectedHeader("WWW-Authenticate").post(this.functionalTestHelper.nodeUri()).response();
        Assert.assertThat((Object)response.getHeaders().getFirst((Object)"WWW-Authenticate"), (Matcher)Matchers.containsString((String)"Basic realm=\"WallyWorld\""));
    }

    @Test
    public void should401WithBasicChallengeIfAnyOneOfTheRulesFails() throws Exception {
        this.server = ServerBuilder.server().withDefaultDatabaseTuning().withSecurityRules(PermanentlyPassingSecurityRule.class.getCanonicalName(), PermanentlyFailingSecurityRule.class.getCanonicalName()).usingDatabaseDir(this.folder.getRoot().getAbsolutePath()).build();
        this.server.start();
        this.functionalTestHelper = new FunctionalTestHelper((NeoServer)this.server);
        JaxRsResponse response = ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(401).expectedHeader("WWW-Authenticate").post(this.functionalTestHelper.nodeUri()).response();
        Assert.assertThat((Object)response.getHeaders().getFirst((Object)"WWW-Authenticate"), (Matcher)Matchers.containsString((String)"Basic realm=\"WallyWorld\""));
    }

    @Test
    public void shouldRespondWith201IfAllTheRulesPassWhenCreatingANode() throws Exception {
        this.server = ServerBuilder.server().withDefaultDatabaseTuning().withSecurityRules(PermanentlyPassingSecurityRule.class.getCanonicalName()).usingDatabaseDir(this.folder.getRoot().getAbsolutePath()).build();
        this.server.start();
        this.functionalTestHelper = new FunctionalTestHelper((NeoServer)this.server);
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(201).expectedHeader("Location").post(this.functionalTestHelper.nodeUri()).response();
    }

    @Test
    @Documented(value=" In this example, a security rule is registered to deny\n access to all URIs to the server by listing the rule(s) class(es) in\n 'neo4j-server.properties'.\n In this case, the rule is registered\n using a wildcard URI path (where `*` characters can be used to signify\n any part of the path). For example `/users*` means the rule\n will be bound to any resources under the `/users` root path. Similarly\n `/users*type*` will bind the rule to resources matching\n URIs like `/users/fred/type/premium`.\n\n @@config\n \n with the rule source code of:\n \n @@failingRuleWithWildcardPath\n \n With this rule registered, any access to URIs under /protected/ will be\n denied by the server. Using wildcards allows flexible targeting of security rules to\n arbitrary parts of the server's API, including any unmanaged extensions or managed\n plugins that have been registered.\n")
    @TestData.Title(value="Using Wildcards to Target Security Rules")
    public void aSimpleWildcardUriPathShould401OnAccessToProtectedSubPath() throws Exception {
        String mountPoint = "/protected/tree/starts/here/dummy";
        this.server = ServerBuilder.server().withDefaultDatabaseTuning().withThirdPartyJaxRsPackage("org.dummy.web.service", mountPoint).withSecurityRules(PermanentlyFailingSecurityRuleWithWildcardPath.class.getCanonicalName()).usingDatabaseDir(this.folder.getRoot().getAbsolutePath()).build();
        this.server.start();
        ((RESTDocsGenerator)((Object)this.gen.get())).addSnippet("config", "\n[source]\n----\norg.neo4j.server.rest.security_rules=my.rules.PermanentlyFailingSecurityRuleWithWildcardPath\n----\n");
        ((RESTDocsGenerator)((Object)this.gen.get())).addTestSourceSnippets(PermanentlyFailingSecurityRuleWithWildcardPath.class, new String[]{"failingRuleWithWildcardPath"});
        ((RESTDocsGenerator)((Object)this.gen.get())).setSection("ops");
        this.functionalTestHelper = new FunctionalTestHelper((NeoServer)this.server);
        JaxRsResponse clientResponse = ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(401).expectedType(MediaType.APPLICATION_JSON_TYPE).expectedHeader("WWW-Authenticate").get(this.trimTrailingSlash(this.functionalTestHelper.baseUri()) + mountPoint + "/more/stuff").response();
        Assert.assertEquals((long)401L, (long)clientResponse.getStatus());
    }

    @Test
    @Documented(value=" In this example, a security rule is registered to deny\n access to all URIs matching a complex pattern.\n The config looks like this:\n\n @@config\n \n with the rule source code of:\n \n @@failingRuleWithComplexWildcardPath\n")
    @TestData.Title(value="Using Complex Wildcards to Target Security Rules")
    public void aComplexWildcardUriPathShould401OnAccessToProtectedSubPath() throws Exception {
        String mountPoint = "/protected/wildcard_replacement/x/y/z/something/else/more_wildcard_replacement/a/b/c/final/bit";
        this.server = ServerBuilder.server().withDefaultDatabaseTuning().withThirdPartyJaxRsPackage("org.dummy.web.service", mountPoint).withSecurityRules(PermanentlyFailingSecurityRuleWithComplexWildcardPath.class.getCanonicalName()).usingDatabaseDir(this.folder.getRoot().getAbsolutePath()).build();
        this.server.start();
        ((RESTDocsGenerator)((Object)this.gen.get())).addSnippet("config", "\n[source]\n----\norg.neo4j.server.rest.security_rules=my.rules.PermanentlyFailingSecurityRuleWithComplexWildcardPath\n----\n");
        ((RESTDocsGenerator)((Object)this.gen.get())).addTestSourceSnippets(PermanentlyFailingSecurityRuleWithComplexWildcardPath.class, new String[]{"failingRuleWithComplexWildcardPath"});
        ((RESTDocsGenerator)((Object)this.gen.get())).setSection("ops");
        this.functionalTestHelper = new FunctionalTestHelper((NeoServer)this.server);
        JaxRsResponse clientResponse = ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(401).expectedType(MediaType.APPLICATION_JSON_TYPE).expectedHeader("WWW-Authenticate").get(this.trimTrailingSlash(this.functionalTestHelper.baseUri()) + mountPoint + "/more/stuff").response();
        Assert.assertEquals((long)401L, (long)clientResponse.getStatus());
    }

    private String trimTrailingSlash(URI uri) {
        String result = uri.toString();
        if (result.endsWith("/")) {
            return result.substring(0, result.length() - 1);
        }
        return result;
    }
}

