/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rrd;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.server.rrd.sampler.RelationshipCountSampleable;
import org.neo4j.test.ImpermanentGraphDatabase;

public class RelationshipCountSampleableTest {
    public ImpermanentGraphDatabase db;
    public RelationshipCountSampleable sampleable;

    @Test
    public void emptyDbHasZeroRelationships() {
        MatcherAssert.assertThat((Object)this.sampleable.getValue(), (Matcher)Is.is((Object)0.0));
    }

    @Test
    public void addANodeAndSampleableGoesUp() {
        this.createARelationship((GraphDatabaseAPI)this.db);
        MatcherAssert.assertThat((Object)this.sampleable.getValue(), (Matcher)Is.is((Object)1.0));
    }

    private void createARelationship(GraphDatabaseAPI db) {
        Transaction tx = db.beginTx();
        Node node1 = db.createNode();
        Node node2 = db.createNode();
        node1.createRelationshipTo(node2, (RelationshipType)DynamicRelationshipType.withName((String)"friend"));
        tx.success();
        tx.finish();
    }

    @Before
    public void setUp() throws Exception {
        this.db = new ImpermanentGraphDatabase();
        this.sampleable = new RelationshipCountSampleable((GraphDatabaseAPI)this.db);
    }

    @After
    public void shutdownDatabase() {
        this.db.shutdown();
    }
}

