/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.preflight;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration.Configuration;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.server.configuration.MapBasedConfiguration;
import org.neo4j.server.preflight.PerformUpgradeIfNecessary;

public class TestPerformUpgradeIfNecessary {
    public static final String HOME_DIRECTORY = "target/" + TestPerformUpgradeIfNecessary.class.getSimpleName();
    public static final String STORE_DIRECTORY = HOME_DIRECTORY + "/data/graph.db";

    @Test
    public void shouldExitImmediatelyIfStoreIsAlreadyAtLatestVersion() throws IOException {
        Configuration serverConfig = this.buildProperties(false);
        new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(STORE_DIRECTORY).newGraphDatabase().shutdown();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PerformUpgradeIfNecessary upgrader = new PerformUpgradeIfNecessary(serverConfig, this.loadNeo4jProperties(), new PrintStream(outputStream));
        boolean exit = upgrader.run();
        Assert.assertEquals((Object)true, (Object)exit);
        Assert.assertEquals((Object)"", (Object)new String(outputStream.toByteArray()));
    }

    @Test
    public void shouldGiveHelpfulMessageIfAutoUpgradeParameterNotSet() throws IOException {
        Configuration serverProperties = this.buildProperties(false);
        TestPerformUpgradeIfNecessary.prepareSampleLegacyDatabase(new File(STORE_DIRECTORY));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PerformUpgradeIfNecessary upgrader = new PerformUpgradeIfNecessary(serverProperties, this.loadNeo4jProperties(), new PrintStream(outputStream));
        boolean exit = upgrader.run();
        Assert.assertEquals((Object)false, (Object)exit);
        String[] lines = new String(outputStream.toByteArray()).split("\\r?\\n");
        Assert.assertThat((String)("'" + lines[0] + "' contains '" + "To enable automatic upgrade, please set configuration parameter " + "\"allow_store_upgrade=true\""), (Object)lines[0].contains("To enable automatic upgrade, please set configuration parameter \"allow_store_upgrade=true\""), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldExitCleanlyIfDatabaseMissingSoThatDatabaseCreationIsLeftToMainProcess() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PerformUpgradeIfNecessary upgrader = new PerformUpgradeIfNecessary(this.buildProperties(true), this.loadNeo4jProperties(), new PrintStream(outputStream));
        boolean exit = upgrader.run();
        Assert.assertEquals((Object)true, (Object)exit);
        Assert.assertEquals((Object)"", (Object)new String(outputStream.toByteArray()));
    }

    @Test
    public void shouldUpgradeDatabase() throws IOException {
        Configuration serverConfig = this.buildProperties(true);
        TestPerformUpgradeIfNecessary.prepareSampleLegacyDatabase(new File(STORE_DIRECTORY));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PerformUpgradeIfNecessary upgrader = new PerformUpgradeIfNecessary(serverConfig, this.loadNeo4jProperties(), new PrintStream(outputStream));
        boolean exit = upgrader.run();
        Assert.assertEquals((Object)true, (Object)exit);
        String[] lines = new String(outputStream.toByteArray()).split("\\r?\\n");
        Assert.assertEquals((Object)"Starting upgrade of database store files", (Object)lines[0]);
        Assert.assertEquals((Object)this.dots(100), (Object)lines[1]);
        Assert.assertEquals((Object)"Finished upgrade of database store files", (Object)lines[2]);
    }

    private Configuration buildProperties(boolean allowStoreUpgrade) throws IOException {
        FileUtils.deleteRecursively((File)new File(HOME_DIRECTORY));
        new File(HOME_DIRECTORY + "/conf").mkdirs();
        Properties databaseProperties = new Properties();
        if (allowStoreUpgrade) {
            databaseProperties.setProperty(GraphDatabaseSettings.allow_store_upgrade.name(), "true");
        }
        String databasePropertiesFileName = HOME_DIRECTORY + "/conf/neo4j.properties";
        databaseProperties.store(new FileWriter(databasePropertiesFileName), null);
        MapBasedConfiguration serverProperties = new MapBasedConfiguration();
        serverProperties.setProperty("org.neo4j.server.database.location", (Object)STORE_DIRECTORY);
        serverProperties.setProperty("org.neo4j.server.db.tuning.properties", (Object)databasePropertiesFileName);
        return serverProperties;
    }

    private Map<String, String> loadNeo4jProperties() throws IOException {
        String databasePropertiesFileName = HOME_DIRECTORY + "/conf/neo4j.properties";
        return MapUtil.load((File)new File(databasePropertiesFileName));
    }

    public static void prepareSampleLegacyDatabase(File workingDirectory) throws IOException {
        File resourceDirectory = TestPerformUpgradeIfNecessary.findOldFormatStoreDirectory();
        FileUtils.deleteRecursively((File)workingDirectory);
        Assert.assertTrue((boolean)workingDirectory.mkdirs());
        FileUtils.copyRecursively((File)resourceDirectory, (File)workingDirectory);
    }

    public static File findOldFormatStoreDirectory() {
        URL legacyStoreResource = TestPerformUpgradeIfNecessary.class.getResource("legacystore/exampledb/neostore");
        return new File(legacyStoreResource.getFile()).getParentFile();
    }

    private String dots(int count) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            builder.append(".");
        }
        return builder.toString();
    }
}

